-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;




--
-- Definition of table `access_group`
--

DROP TABLE IF EXISTS `access_group`;
CREATE TABLE `access_group` (
  `idaccess_group` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `canAddExpedient` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `canEditExpedient` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `canViewExpedient` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idaccess_group`),
  KEY `fk_access_group_process1_idx` (`process_idprocess`),
  CONSTRAINT `fk_access_group_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `access_group`
--

/*!40000 ALTER TABLE `access_group` DISABLE KEYS */;
INSERT INTO `access_group` (`idaccess_group`,`process_idprocess`,`code`,`title`,`canAddExpedient`,`canEditExpedient`,`canViewExpedient`) VALUES 
 (1,1,'Employee','Any Company Employee','1','0','1'),
 (2,1,'RRHH','Human Resources','0','0','1'),
 (3,1,'Payer','Cash / Payer','0','0','1'),
 (4,1,'Admin','Administrator and Test','1','1','1'),
 (5,2,'Admin','Administrator','1','1','1'),
 (6,2,'Employee','Any Company Employee','1','0','1'),
 (7,2,'RRHH','Human Resources','0','0','1'),
 (8,2,'Accounting','General accounting and cash','0','0','1');
/*!40000 ALTER TABLE `access_group` ENABLE KEYS */;


--
-- Definition of table `alerts`
--

DROP TABLE IF EXISTS `alerts`;
CREATE TABLE `alerts` (
  `idalerts` int(11) NOT NULL AUTO_INCREMENT,
  `expedient_idexpedient` int(11) NOT NULL,
  `creationDate` datetime NOT NULL,
  `alertDate` date NOT NULL,
  `alertClass` int(11) NOT NULL,
  `situation` int(11) NOT NULL,
  `observations` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `creationUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `lastUpdateDate` datetime NOT NULL,
  `lastUpdateUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idalerts`),
  KEY `fk_alerts_expedient1_idx` (`expedient_idexpedient`),
  CONSTRAINT `fk_alerts_expedient1` FOREIGN KEY (`expedient_idexpedient`) REFERENCES `expedient` (`idexpedient`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `alerts`
--

/*!40000 ALTER TABLE `alerts` DISABLE KEYS */;
INSERT INTO `alerts` (`idalerts`,`expedient_idexpedient`,`creationDate`,`alertDate`,`alertClass`,`situation`,`observations`,`creationUser`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (1,1,'2020-03-23 20:56:07','2020-04-02',0,0,'','admin','2020-03-23 20:56:07','admin'),
 (2,1,'2020-03-25 19:03:30','2020-03-25',0,0,'','admin','2020-03-25 19:03:30','admin'),
 (3,1,'2020-03-25 19:04:03','2020-03-24',0,1,'','admin','2020-03-25 19:04:03','admin'),
 (4,1,'2020-03-25 19:04:19','2020-03-26',0,2,'','admin','2020-03-25 19:04:19','admin'),
 (5,4,'2020-04-06 14:31:52','2020-04-03',0,0,'','admin','2020-04-06 14:31:52','admin');
/*!40000 ALTER TABLE `alerts` ENABLE KEYS */;


--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalogNum` int(11) NOT NULL,
  `catalogCode` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `groupNum` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`catalogNum`),
  KEY `idx2_calatalog` (`groupNum`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalogNum`,`catalogCode`,`description`,`groupNum`) VALUES 
 (1,4,'',0,'English','Inglés',NULL),
 (2,4,'',1,'Spanish','Español',NULL),
 (3,1,'Spanish',1,'Pte. Revisión Jefe inmediato','Pte. Revisión Jefe inmediato',NULL),
 (4,1,'Spanish',2,'Pte. denegación','Pte. denegación',NULL),
 (5,1,'Spanish',3,'Pte. revisión de RRHH','Pte. revisión de RRHH',NULL),
 (6,1,'Spanish',4,'Pte. aviso de pago','Pte. aviso de pago',NULL),
 (7,1,'Spanish',5,'Pte. de Pago','Pte. de Pago',NULL),
 (8,1,'Spanish',6,'Pte. descuento en nómina','Pte. descuento en nómina',NULL),
 (9,1,'Spanish',7,'Archivado / Finalizado','Archivado / Finalizado',NULL),
 (10,1,'English',1,'Pending review Immediate boss','Pendiente de revisión Jefe inmediato',NULL),
 (11,1,'English',2,'Pending Denial','Pendiente denegación',NULL),
 (12,1,'English',3,'Pending HR review','Pendiente revisión de RRHH',NULL),
 (13,1,'English',4,'Pending payment notice','Pendiente aviso de pago',NULL),
 (14,1,'English',5,'Outstanding','Pendiente de Pago',NULL),
 (15,1,'English',6,'Pending payroll discount','Pendiente descuento en nómina',NULL),
 (16,1,'English',7,'Filed / Finished','Archivado / Finalizado',NULL),
 (17,2,'Spanish',1,'Revisión','',NULL),
 (18,2,'Spanish',2,'Revisión RRHH','',NULL),
 (19,2,'Spanish',3,'Avisar del Pago','',NULL),
 (20,2,'Spanish',4,'Denegación','',NULL),
 (21,2,'Spanish',5,'Pago del Anticipo','',NULL),
 (22,2,'Spanish',6,'Descuento en nómina','',NULL),
 (23,2,'English',1,'Revision','',NULL),
 (24,2,'English',2,'HR Review','',NULL),
 (25,2,'English',3,'Notice of Payment','',NULL),
 (26,2,'English',4,'Denial','',NULL),
 (27,2,'English',5,'Advance Payment','',NULL),
 (28,2,'English',6,'Payroll Discount','',NULL),
 (29,3,'Spanish',1,'Modificar Expediente','Modificar Expediente',NULL),
 (30,3,'Spanish',2,'Listado de exptes por Estado','Listado de exptes por Estado',NULL),
 (31,3,'Spanish',3,'Impresión del Expediente','Impresión del Expediente',NULL),
 (32,3,'English',1,'Updated Expedient','',NULL),
 (33,3,'English',2,'List of records for Status','',NULL),
 (34,3,'English',3,'Expedient Printing','',NULL),
 (35,5,'Spanish',1,'Pte. Completar información','',NULL),
 (36,5,'Spanish',2,'Pte. Revisión de gastos','',NULL),
 (37,5,'Spanish',3,'Pte. Revisar por Contabilidad','',NULL),
 (38,5,'Spanish',4,'Pte. Aplicar a nómina','',NULL),
 (39,5,'Spanish',5,'Finalizar','',NULL),
 (40,5,'Spanish',6,'Archivado','',NULL),
 (41,5,'Spanish',7,'Fin','',NULL),
 (42,5,'English',1,'Pending Complete Information','',NULL),
 (43,5,'English',2,'Pending Expediture Review','',NULL),
 (44,5,'English',3,'Pending Accounting Review','',NULL),
 (45,5,'English',4,'Pending to apply on payroll','',NULL),
 (46,5,'English',5,'Finalize','',NULL),
 (47,5,'English',6,'Archived','',NULL),
 (48,5,'English',7,'The End','',NULL),
 (49,6,'Spanish',1,'Completar información','',NULL),
 (50,6,'Spanish',2,'Denegar petición','',NULL),
 (51,6,'Spanish',3,'Autorizado','',NULL),
 (52,6,'Spanish',4,'Subsanar errores','',NULL),
 (53,6,'Spanish',5,'Solicitar aplicar a nómina','',NULL),
 (54,6,'Spanish',6,'A contabilización','',NULL),
 (55,6,'Spanish',7,'Finalizar','',NULL),
 (56,6,'Spanish',8,'Terminar','',NULL),
 (57,6,'English',1,'Complete information','',NULL),
 (58,6,'English',2,'Deny request','',NULL),
 (59,6,'English',3,'Authorized','',NULL),
 (60,6,'English',4,'Fix errors','',NULL),
 (61,6,'English',5,'Request payroll application','',NULL),
 (62,6,'English',6,'To accounting','',NULL),
 (63,6,'English',7,'Conclude','',NULL),
 (64,6,'English',8,'Finish','',NULL),
 (67,6,'Spanish',9,'Solución de problemas','',NULL),
 (68,6,'English',9,'Troubleshooting','',NULL),
 (69,8,'Spanish',0,'Espera de Documentación','',NULL),
 (70,8,'Spanish',1,'Plazo de reclamación de resolución','',NULL),
 (71,8,'Spanish',2,'Otros plazos legales','',NULL),
 (72,8,'Spanish',3,'Especial tratamiento','',NULL),
 (73,8,'English',0,'Waiting for Documentation','',NULL),
 (74,8,'English',1,'Term of claim for resolution','',NULL),
 (75,8,'English',2,'Other legal terms','',NULL),
 (76,8,'English',3,'Special treatment','',NULL),
 (77,9,'Spanish',0,'Activa','',NULL),
 (78,9,'Spanish',1,'Pausada','',NULL),
 (79,9,'Spanish',2,'Vencida o Archivada','',NULL),
 (80,9,'English',0,'Active','',NULL),
 (81,9,'English',1,'Pause','',NULL),
 (82,9,'English',2,'Expired or Archived','',NULL),
 (83,10,'Spanish',0,'Entrada','',NULL),
 (84,10,'Spanish',1,'Salida','',NULL),
 (85,10,'English',0,'Entry','',NULL),
 (86,10,'English',1,'Exit','',NULL),
 (87,11,'Spanish',1,'Taxis','',NULL),
 (88,11,'Spanish',2,'Gasolina o Diesel','',NULL),
 (89,11,'Spanish',3,'Peajes','',NULL),
 (90,11,'Spanish',4,'Aparcamientos','',NULL),
 (91,11,'Spanish',5,'Desayunos, comidas y cenas','',NULL),
 (92,11,'English',6,'Invitaciones Clientes','',NULL),
 (93,11,'Spanish',7,'Hoteles','',NULL),
 (94,11,'English',1,'Taxis','',NULL),
 (95,11,'English',2,'Petrol or Diesel','',NULL),
 (96,11,'English',3,'Tolls','',NULL),
 (97,11,'English',4,'Parking','',NULL),
 (98,11,'English',5,'Breakfasts, lunches and dinners','',NULL),
 (99,11,'English',6,'Customer Invitations','',NULL),
 (100,11,'English',7,'Hotels','',NULL),
 (101,7,'Spanish',1,'Modificar Expediente','',NULL),
 (102,7,'English',1,'Updated Expedient','',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `idconfig` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idconfig`),
  UNIQUE KEY `idx1_config` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`idconfig`,`name`,`value`) VALUES 
 (1,'FILE_CODE_REPORT','files/code_report'),
 (2,'FILE_CONDITION_REPORT','files/conditions_report'),
 (3,'FILE_TEMPLATE','files/template'),
 (4,'FILES_DOCUMENT','files/document'),
 (5,'DOCUMENT_ROOT_WF2','../../');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `ct_num_document`
--

DROP TABLE IF EXISTS `ct_num_document`;
CREATE TABLE `ct_num_document` (
  `idnum_document` int(11) NOT NULL AUTO_INCREMENT,
  `codePrefix` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `year` int(11) NOT NULL,
  `nextNumber` int(11) NOT NULL,
  PRIMARY KEY (`idnum_document`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_num_document`
--

/*!40000 ALTER TABLE `ct_num_document` DISABLE KEYS */;
INSERT INTO `ct_num_document` (`idnum_document`,`codePrefix`,`year`,`nextNumber`) VALUES 
 (1,'DOC',2020,71);
/*!40000 ALTER TABLE `ct_num_document` ENABLE KEYS */;


--
-- Definition of table `ct_num_expedient`
--

DROP TABLE IF EXISTS `ct_num_expedient`;
CREATE TABLE `ct_num_expedient` (
  `idnum_expedient` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `codePrefix` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `year` int(11) NOT NULL,
  `nextNumber` int(11) NOT NULL,
  PRIMARY KEY (`idnum_expedient`),
  KEY `fk_ct_num_expedient_process1_idx` (`process_idprocess`),
  CONSTRAINT `fk_ct_num_expedient_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_num_expedient`
--

/*!40000 ALTER TABLE `ct_num_expedient` DISABLE KEYS */;
INSERT INTO `ct_num_expedient` (`idnum_expedient`,`process_idprocess`,`codePrefix`,`year`,`nextNumber`) VALUES 
 (1,2,'EX01',2020,2),
 (2,1,'EX04',2020,18);
/*!40000 ALTER TABLE `ct_num_expedient` ENABLE KEYS */;


--
-- Definition of table `ct_proceeding`
--

DROP TABLE IF EXISTS `ct_proceeding`;
CREATE TABLE `ct_proceeding` (
  `idct_proceeding` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `catalogNum` int(11) NOT NULL COMMENT 'Title',
  `importanceWeight` int(11) NOT NULL,
  `urlProceeding` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idct_proceeding`),
  KEY `fk_ct_proceeding_process1_idx` (`process_idprocess`),
  CONSTRAINT `fk_ct_proceeding_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_proceeding`
--

/*!40000 ALTER TABLE `ct_proceeding` DISABLE KEYS */;
INSERT INTO `ct_proceeding` (`idct_proceeding`,`process_idprocess`,`catalogNum`,`importanceWeight`,`urlProceeding`) VALUES 
 (1,1,1,1,'ex04_proceeding_edit.php'),
 (2,1,2,2,'ex04_proceeding_edit.php'),
 (3,1,3,3,'ex04_proceeding_edit.php'),
 (4,1,4,4,'ex04_proceeding_edit.php'),
 (5,1,5,5,'ex04_proceeding_edit.php'),
 (6,1,6,6,'ex04_proceeding_edit.php'),
 (7,2,1,1,'ex01_proceeding_edit.php'),
 (8,2,2,2,'ex01_proceeding_edit.php'),
 (9,2,3,3,'ex01_proceeding_edit.php'),
 (10,2,4,4,'ex01_proceeding_edit.php'),
 (11,2,5,5,'ex01_proceeding_edit.php'),
 (12,2,6,6,'ex01_proceeding_edit.php'),
 (13,2,7,7,'ex01_proceeding_edit.php'),
 (14,2,8,8,'ex01_proceeding_edit.php'),
 (15,2,9,9,'ex01_proceeding_edit.php');
/*!40000 ALTER TABLE `ct_proceeding` ENABLE KEYS */;


--
-- Definition of table `ct_report`
--

DROP TABLE IF EXISTS `ct_report`;
CREATE TABLE `ct_report` (
  `idct_report` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `ct_proceeding_idct_proceeding` int(11) DEFAULT NULL,
  `ct_utility_idct_utility` int(11) DEFAULT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `isPHPWord` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isPHPExcel` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `codeTemplateFiles` varchar(800) COLLATE utf8_unicode_ci DEFAULT NULL,
  `conditionFile` varchar(800) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastUpdateDate` datetime NOT NULL,
  `lastUpdateUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idct_report`),
  KEY `fk_ct_report_process1_idx` (`process_idprocess`),
  KEY `fk_ct_report_ct_proceeding1_idx` (`ct_proceeding_idct_proceeding`),
  KEY `fk_ct_report_ct_utility1_idx` (`ct_utility_idct_utility`),
  CONSTRAINT `fk_ct_report_ct_proceeding1` FOREIGN KEY (`ct_proceeding_idct_proceeding`) REFERENCES `ct_proceeding` (`idct_proceeding`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ct_report_ct_utility1` FOREIGN KEY (`ct_utility_idct_utility`) REFERENCES `ct_utility` (`idct_utility`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ct_report_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_report`
--

/*!40000 ALTER TABLE `ct_report` DISABLE KEYS */;
INSERT INTO `ct_report` (`idct_report`,`process_idprocess`,`ct_proceeding_idct_proceeding`,`ct_utility_idct_utility`,`title`,`isPHPWord`,`isPHPExcel`,`codeTemplateFiles`,`conditionFile`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (1,1,2,NULL,'Peticion','1','0','[{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_x0z7gl5d.txt\",\"usrName\":\"plantilla_ejemplo_1.txt\",\"size\":2525,\"type\":\"text\\/plain\"}]','[{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_gml8zb95.txt\",\"usrName\":\"CondicionInformeEjemplo.txt\",\"size\":318,\"type\":\"text\\/plain\",\"searchStr\":\"CondicionInformeEjemplo.txt,!:sStrEnd\"}]','2020-04-08 13:07:46','admin'),
 (3,1,2,NULL,'Report_Expedient','0','1','[{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_vno0lkiy.txt\",\"usrName\":\"modelo_2.txt\",\"size\":4221,\"type\":\"text\\/plain\"}]','','2020-04-08 13:16:42','admin'),
 (4,1,NULL,3,'Listado','0','1','[{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_bzpn70rq.txt\",\"usrName\":\"modelo_2.txt\",\"size\":4221,\"type\":\"text\\/plain\"}]','','2020-04-08 13:13:59','admin'),
 (5,1,NULL,2,'','0','1','[{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_cyv1j0ib.txt\",\"usrName\":\"modelo_3.txt\",\"size\":7307,\"type\":\"text\\/plain\"}]','','2020-04-08 13:14:11','admin');
/*!40000 ALTER TABLE `ct_report` ENABLE KEYS */;


--
-- Definition of table `ct_status`
--

DROP TABLE IF EXISTS `ct_status`;
CREATE TABLE `ct_status` (
  `idct_status` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `catalogNum` int(11) NOT NULL,
  `isTheEnd` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idct_status`),
  KEY `fk_ct_status_process1_idx` (`process_idprocess`),
  CONSTRAINT `fk_ct_status_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_status`
--

/*!40000 ALTER TABLE `ct_status` DISABLE KEYS */;
INSERT INTO `ct_status` (`idct_status`,`process_idprocess`,`catalogNum`,`isTheEnd`) VALUES 
 (1,1,1,'0'),
 (2,1,2,'0'),
 (3,1,3,'0'),
 (4,1,4,'0'),
 (5,1,5,'0'),
 (6,1,6,'0'),
 (7,1,7,'1'),
 (8,2,1,'0'),
 (9,2,2,'0'),
 (10,2,3,'0'),
 (11,2,4,'0'),
 (12,2,5,'0'),
 (13,2,6,'0'),
 (14,2,7,'1');
/*!40000 ALTER TABLE `ct_status` ENABLE KEYS */;


--
-- Definition of table `ct_templates`
--

DROP TABLE IF EXISTS `ct_templates`;
CREATE TABLE `ct_templates` (
  `idct_templates` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fileContent` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `lastUpdateDate` datetime NOT NULL,
  `lastUpdateUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idct_templates`),
  KEY `fk_ct_templates_process1_idx` (`process_idprocess`),
  CONSTRAINT `fk_ct_templates_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_templates`
--

/*!40000 ALTER TABLE `ct_templates` DISABLE KEYS */;
INSERT INTO `ct_templates` (`idct_templates`,`process_idprocess`,`title`,`fileContent`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (1,1,'Example of Template','[{\"name\":\"files\\/template\\/plantilla ejemplo 1_fashkepc.docx\",\"usrName\":\"plantilla ejemplo 1.docx\",\"size\":15152,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo 1.docx,!:sStrEnd\"}]','2020-02-07 20:46:05','admin');
/*!40000 ALTER TABLE `ct_templates` ENABLE KEYS */;


--
-- Definition of table `ct_utility`
--

DROP TABLE IF EXISTS `ct_utility`;
CREATE TABLE `ct_utility` (
  `idct_utility` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `catalogNum` int(11) NOT NULL COMMENT 'Title',
  `importanceWeight` int(11) NOT NULL,
  `urlUtility` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idct_utility`),
  KEY `fk_ct_utility_process1_idx` (`process_idprocess`),
  CONSTRAINT `fk_ct_utility_process1` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ct_utility`
--

/*!40000 ALTER TABLE `ct_utility` DISABLE KEYS */;
INSERT INTO `ct_utility` (`idct_utility`,`process_idprocess`,`catalogNum`,`importanceWeight`,`urlUtility`) VALUES 
 (1,1,1,1,'ex04_utility_edit.php'),
 (2,1,2,2,'ex04_report_edit.php'),
 (3,1,3,3,'ex04_report_edit.php'),
 (4,2,1,1,'ex01_utility_edit.php');
/*!40000 ALTER TABLE `ct_utility` ENABLE KEYS */;


--
-- Definition of table `document`
--

DROP TABLE IF EXISTS `document`;
CREATE TABLE `document` (
  `iddocument` int(11) NOT NULL AUTO_INCREMENT,
  `expedient_idexpedient` int(11) NOT NULL,
  `DocumentNum` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `Title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `entryOrExit` int(11) NOT NULL DEFAULT '0',
  `fileContent` varchar(800) COLLATE utf8_unicode_ci DEFAULT NULL,
  `creationDate` datetime NOT NULL,
  `lastUpdateDate` datetime NOT NULL,
  `lastUpdateUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`iddocument`),
  KEY `fk_document_expedient1_idx` (`expedient_idexpedient`),
  CONSTRAINT `fk_document_expedient1` FOREIGN KEY (`expedient_idexpedient`) REFERENCES `expedient` (`idexpedient`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `document`
--

/*!40000 ALTER TABLE `document` DISABLE KEYS */;
INSERT INTO `document` (`iddocument`,`expedient_idexpedient`,`DocumentNum`,`Title`,`entryOrExit`,`fileContent`,`creationDate`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (58,1,'DOC/000067/2020','Peticion',1,'[{\"name\":\"files/document/EX04_000004_2020/Peticion_20200408131708.docx\",\"usrName\":\"Peticion_20200408131708.docx\",\"size\":14202,\"type\":\"application/word\"}]','2020-04-08 13:17:08','2020-04-08 13:17:08','admin'),
 (59,1,'DOC/000068/2020','Report_Expedient',1,'[{\"name\":\"files/document/EX04_000004_2020/Report_Expedient_20200408131708.xlsx\",\"usrName\":\"Report_Expedient_20200408131708.xlsx\",\"size\":10318,\"type\":\"application/excel\"}]','2020-04-08 13:17:08','2020-04-08 13:17:08','admin'),
 (60,2,'DOC/000069/2020','Peticion',1,'[{\"name\":\"files/document/EX04_000008_2020/Peticion_20200408131825.docx\",\"usrName\":\"Peticion_20200408131825.docx\",\"size\":14202,\"type\":\"application/word\"}]','2020-04-08 13:18:25','2020-04-08 13:18:25','admin'),
 (61,2,'DOC/000070/2020','Report_Expedient',1,'[{\"name\":\"files/document/EX04_000008_2020/Report_Expedient_20200408131825.xlsx\",\"usrName\":\"Report_Expedient_20200408131825.xlsx\",\"size\":10166,\"type\":\"application/excel\"}]','2020-04-08 13:18:25','2020-04-08 13:18:25','admin');
/*!40000 ALTER TABLE `document` ENABLE KEYS */;


--
-- Definition of table `ex01_liquidation`
--

DROP TABLE IF EXISTS `ex01_liquidation`;
CREATE TABLE `ex01_liquidation` (
  `idex01_liquidation` int(11) NOT NULL AUTO_INCREMENT,
  `expedient_idexpedient` int(11) NOT NULL,
  `expense_code` int(11) NOT NULL,
  `expense_value` decimal(10,2) NOT NULL,
  PRIMARY KEY (`idex01_liquidation`),
  KEY `fk_ex01_liquidation_expedient1_idx` (`expedient_idexpedient`),
  CONSTRAINT `fk_ex01_liquidation_expedient1` FOREIGN KEY (`expedient_idexpedient`) REFERENCES `expedient` (`idexpedient`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ex01_liquidation`
--

/*!40000 ALTER TABLE `ex01_liquidation` DISABLE KEYS */;
INSERT INTO `ex01_liquidation` (`idex01_liquidation`,`expedient_idexpedient`,`expense_code`,`expense_value`) VALUES 
 (1,4,2,'15.52'),
 (2,4,1,'100.00');
/*!40000 ALTER TABLE `ex01_liquidation` ENABLE KEYS */;


--
-- Definition of table `expedient`
--

DROP TABLE IF EXISTS `expedient`;
CREATE TABLE `expedient` (
  `idexpedient` int(11) NOT NULL AUTO_INCREMENT,
  `process_idprocess` int(11) NOT NULL,
  `ct_status_idct_status` int(11) NOT NULL,
  `codeExpedient` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(225) COLLATE utf8_unicode_ci NOT NULL,
  `observations` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `assignedUser` int(11) DEFAULT NULL,
  `creationDate` datetime NOT NULL,
  `creationUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `lastUpdateDate` datetime NOT NULL,
  `lastUpdateUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `finishDate` datetime DEFAULT NULL,
  `ex04_advanceAmount` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`idexpedient`),
  KEY `fk_expedient_process_idx` (`process_idprocess`),
  KEY `fk_expedient_ct_status1_idx` (`ct_status_idct_status`),
  CONSTRAINT `fk_expedient_ct_status1` FOREIGN KEY (`ct_status_idct_status`) REFERENCES `ct_status` (`idct_status`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_expedient_process` FOREIGN KEY (`process_idprocess`) REFERENCES `process` (`idprocess`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `expedient`
--

/*!40000 ALTER TABLE `expedient` DISABLE KEYS */;
INSERT INTO `expedient` (`idexpedient`,`process_idprocess`,`ct_status_idct_status`,`codeExpedient`,`title`,`observations`,`assignedUser`,`creationDate`,`creationUser`,`lastUpdateDate`,`lastUpdateUser`,`finishDate`,`ex04_advanceAmount`) VALUES 
 (1,1,4,'EX04/000004/2020','Test 4','Observacion.\r\nTexto en varias líneas para ver los efectos en la exportación a Excel.\r\nSaludos, ',NULL,'2020-03-23 18:35:12','user1','2020-04-08 13:17:02','admin','2020-04-03 14:21:26','3000.00'),
 (2,1,4,'EX04/000008/2020','Test 2','',NULL,'2020-03-26 19:31:47','user2','2020-04-08 13:18:20','admin',NULL,'3500.00'),
 (3,1,3,'EX04/000017/2020','Test 5','Observation ......',NULL,'2020-04-03 17:36:13','user1','2020-04-03 18:39:04','boss1',NULL,'4000.00'),
 (4,2,10,'EX01/000001/2020','Test 1','',NULL,'2020-04-06 14:19:59','admin','2020-04-06 20:41:37','admin',NULL,'0.00');
/*!40000 ALTER TABLE `expedient` ENABLE KEYS */;


--
-- Definition of table `interested`
--

DROP TABLE IF EXISTS `interested`;
CREATE TABLE `interested` (
  `idinterested` int(11) NOT NULL AUTO_INCREMENT,
  `expedient_idexpedient` int(11) NOT NULL,
  `typeInterested` int(11) NOT NULL DEFAULT '0',
  `taxIdentificationNumber` varchar(13) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstSurname` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `secondSurname` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `businessName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domicile` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `municipality` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobil` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idinterested`),
  KEY `fk_interested_expedient1_idx` (`expedient_idexpedient`),
  CONSTRAINT `fk_interested_expedient1` FOREIGN KEY (`expedient_idexpedient`) REFERENCES `expedient` (`idexpedient`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `interested`
--

/*!40000 ALTER TABLE `interested` DISABLE KEYS */;
/*!40000 ALTER TABLE `interested` ENABLE KEYS */;


--
-- Definition of table `proceeding_status`
--

DROP TABLE IF EXISTS `proceeding_status`;
CREATE TABLE `proceeding_status` (
  `idproceeding_status` int(11) NOT NULL AUTO_INCREMENT,
  `ct_proceeding_idct_proceeding` int(11) NOT NULL,
  `ct_status_idct_status` int(11) NOT NULL,
  PRIMARY KEY (`idproceeding_status`),
  KEY `fk_proceeding_status_ct_proceeding1_idx` (`ct_proceeding_idct_proceeding`),
  KEY `fk_proceeding_status_ct_status1_idx` (`ct_status_idct_status`),
  CONSTRAINT `fk_proceeding_status_ct_proceeding1` FOREIGN KEY (`ct_proceeding_idct_proceeding`) REFERENCES `ct_proceeding` (`idct_proceeding`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_proceeding_status_ct_status1` FOREIGN KEY (`ct_status_idct_status`) REFERENCES `ct_status` (`idct_status`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `proceeding_status`
--

/*!40000 ALTER TABLE `proceeding_status` DISABLE KEYS */;
INSERT INTO `proceeding_status` (`idproceeding_status`,`ct_proceeding_idct_proceeding`,`ct_status_idct_status`) VALUES 
 (1,1,2),
 (2,1,3),
 (3,2,4),
 (4,2,2),
 (5,3,5),
 (6,4,7),
 (7,5,6),
 (8,6,7),
 (9,7,8),
 (10,8,13),
 (11,9,10),
 (12,10,9),
 (13,11,11),
 (14,12,12),
 (15,13,14),
 (16,14,14),
 (17,15,9);
/*!40000 ALTER TABLE `proceeding_status` ENABLE KEYS */;


--
-- Definition of table `process`
--

DROP TABLE IF EXISTS `process`;
CREATE TABLE `process` (
  `idprocess` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `superCodeStatus` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `superCodeProceeding` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `superCodeUtility` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `urlAdd` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `urlEdit` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `urlView` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idprocess`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `process`
--

/*!40000 ALTER TABLE `process` DISABLE KEYS */;
INSERT INTO `process` (`idprocess`,`code`,`title`,`superCodeStatus`,`superCodeProceeding`,`superCodeUtility`,`urlAdd`,`urlEdit`,`urlView`) VALUES 
 (1,'EX04','Cash advances','EX04_STATUS','EX04_TASK','EX04_UTIL','ex04_expedient_add.php','ex04_expedient_edit.php','ex04_expedient_view.php'),
 (2,'EX01','Travel Expenses settlement','EX01_STATUS','EX01_TASK','EX01_UTIL','ex01_expedient_add.php','ex01_expedient_edit.php','ex01_expedient_view.php');
/*!40000 ALTER TABLE `process` ENABLE KEYS */;


--
-- Definition of table `process_logbook`
--

DROP TABLE IF EXISTS `process_logbook`;
CREATE TABLE `process_logbook` (
  `idprocess_logbook` int(11) NOT NULL AUTO_INCREMENT,
  `expedient_idexpedient` int(11) NOT NULL,
  `ct_proceeding_idct_proceeding` int(11) DEFAULT NULL,
  `ct_utility_idct_utility` int(11) DEFAULT NULL,
  `beforeStatus` int(11) DEFAULT NULL,
  `afterStatus` int(11) DEFAULT NULL,
  `observations` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastUpdateDate` datetime NOT NULL,
  `lastUpdateUser` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idprocess_logbook`),
  KEY `fk_process_logbook_expedient1_idx` (`expedient_idexpedient`),
  KEY `fk_process_logbook_ct_proceeding1_idx` (`ct_proceeding_idct_proceeding`),
  KEY `fk_process_logbook_ct_utility1_idx` (`ct_utility_idct_utility`),
  CONSTRAINT `fk_process_logbook_ct_proceeding1` FOREIGN KEY (`ct_proceeding_idct_proceeding`) REFERENCES `ct_proceeding` (`idct_proceeding`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_process_logbook_ct_utility1` FOREIGN KEY (`ct_utility_idct_utility`) REFERENCES `ct_utility` (`idct_utility`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_process_logbook_expedient1` FOREIGN KEY (`expedient_idexpedient`) REFERENCES `expedient` (`idexpedient`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `process_logbook`
--

/*!40000 ALTER TABLE `process_logbook` DISABLE KEYS */;
INSERT INTO `process_logbook` (`idprocess_logbook`,`expedient_idexpedient`,`ct_proceeding_idct_proceeding`,`ct_utility_idct_utility`,`beforeStatus`,`afterStatus`,`observations`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (1,1,1,NULL,1,2,'dededeed','2020-03-24 19:49:05','admin'),
 (2,2,1,NULL,1,1,'','2020-03-31 21:02:59','1'),
 (3,2,1,NULL,1,3,'','2020-03-31 21:03:17','1'),
 (4,2,1,NULL,3,3,'','2020-04-01 12:05:12','1'),
 (5,2,2,NULL,3,3,'','2020-04-01 13:59:26','1'),
 (6,2,1,NULL,1,3,'','2020-04-01 17:38:58','1'),
 (7,2,1,NULL,1,3,'','2020-04-01 18:01:14','1'),
 (8,2,2,NULL,3,4,'','2020-04-01 19:11:07','1'),
 (9,2,2,NULL,4,4,'','2020-04-01 19:16:51','1'),
 (10,2,1,NULL,1,3,'','2020-04-01 19:17:12','1'),
 (11,2,2,NULL,3,3,'','2020-04-01 19:19:05','1'),
 (12,2,1,NULL,1,3,'','2020-04-01 19:19:29','1'),
 (13,2,1,NULL,1,3,'','2020-04-01 19:28:19','1'),
 (14,2,1,NULL,1,3,'','2020-04-01 19:36:38','1'),
 (15,2,1,NULL,1,3,'','2020-04-01 19:40:48','1'),
 (16,2,1,NULL,1,3,'','2020-04-01 19:45:44','1'),
 (17,2,1,NULL,1,3,'','2020-04-01 20:13:55','1'),
 (18,2,1,NULL,1,3,'','2020-04-01 20:17:29','1'),
 (19,2,1,NULL,1,3,'','2020-04-01 20:22:22','1'),
 (20,2,1,NULL,1,2,'','2020-04-01 20:35:33','1'),
 (21,2,1,NULL,1,3,'','2020-04-01 20:39:02','1'),
 (22,2,2,NULL,3,4,'','2020-04-01 20:42:45','1'),
 (23,2,1,NULL,1,3,'','2020-04-01 20:50:05','1'),
 (24,2,2,NULL,3,4,'','2020-04-01 20:51:24','1'),
 (25,2,3,NULL,4,5,'','2020-04-01 20:52:32','1'),
 (26,2,5,NULL,5,6,'','2020-04-01 20:53:37','1'),
 (27,2,2,NULL,3,4,'','2020-04-01 20:54:11','1'),
 (28,2,1,NULL,1,3,'','2020-04-01 20:57:58','1'),
 (29,2,2,NULL,3,4,'','2020-04-01 20:58:47','1'),
 (30,2,3,NULL,4,5,'','2020-04-01 21:00:44','1'),
 (31,2,5,NULL,5,6,'','2020-04-01 21:05:31','1'),
 (32,2,1,NULL,1,3,'','2020-04-01 21:07:18','1'),
 (33,2,2,NULL,3,3,'','2020-04-01 21:07:29','1'),
 (34,2,2,NULL,3,4,'','2020-04-01 21:07:40','1'),
 (35,2,1,NULL,1,3,'','2020-04-02 14:12:40','1'),
 (36,2,2,NULL,3,4,'','2020-04-02 14:12:51','1'),
 (37,2,2,NULL,3,4,'','2020-04-02 14:21:30','1'),
 (38,2,2,NULL,3,4,'','2020-04-02 14:23:35','1'),
 (39,1,1,NULL,1,3,'','2020-04-02 18:58:14','1'),
 (40,1,2,NULL,3,4,'','2020-04-02 18:58:32','1'),
 (41,1,3,NULL,4,5,'','2020-04-03 14:19:03','1'),
 (42,1,5,NULL,5,6,'','2020-04-03 14:19:15','1'),
 (43,1,1,NULL,1,3,'','2020-04-03 14:20:37','1'),
 (44,1,2,NULL,3,4,'','2020-04-03 14:20:48','1'),
 (45,1,3,NULL,4,5,'','2020-04-03 14:21:00','1'),
 (46,1,5,NULL,5,6,'','2020-04-03 14:21:08','1'),
 (47,1,6,NULL,6,7,'','2020-04-03 14:21:36','1'),
 (48,1,1,NULL,1,1,'','2020-04-03 17:32:21','1'),
 (49,1,1,NULL,1,1,'','2020-04-03 17:33:15','1'),
 (50,1,1,NULL,1,3,'','2020-04-03 18:11:22','4'),
 (51,3,1,NULL,1,3,'','2020-04-03 18:39:14','4'),
 (52,1,2,NULL,3,4,'','2020-04-03 20:33:55','1'),
 (53,1,2,NULL,3,4,'','2020-04-03 20:35:47','1'),
 (54,1,2,NULL,3,4,'','2020-04-03 20:38:29','1'),
 (55,1,2,NULL,3,4,'','2020-04-03 20:40:09','1'),
 (56,1,2,NULL,3,4,'','2020-04-03 20:50:51','1'),
 (57,1,2,NULL,3,4,'','2020-04-03 20:54:36','1'),
 (58,1,2,NULL,3,4,'','2020-04-03 21:01:55','1'),
 (59,1,2,NULL,3,4,'','2020-04-03 21:04:56','1'),
 (60,1,2,NULL,3,4,'','2020-04-04 14:06:31','1'),
 (61,1,2,NULL,3,4,'','2020-04-04 14:08:47','1'),
 (62,1,2,NULL,3,4,'','2020-04-04 14:10:03','1'),
 (63,1,2,NULL,3,4,'','2020-04-04 14:12:34','1'),
 (64,1,2,NULL,3,4,'','2020-04-04 14:16:35','1'),
 (65,1,2,NULL,3,4,'','2020-04-04 14:18:32','1'),
 (66,1,2,NULL,3,4,'','2020-04-04 17:02:09','1'),
 (67,1,2,NULL,3,4,'','2020-04-04 17:04:25','1'),
 (68,1,1,NULL,1,3,'','2020-04-04 17:36:23','1'),
 (69,1,2,NULL,3,4,'','2020-04-04 17:36:38','1'),
 (70,1,2,NULL,3,4,'','2020-04-04 17:37:34','1'),
 (71,1,2,NULL,3,4,'','2020-04-04 20:40:08','1'),
 (72,1,2,NULL,3,4,'','2020-04-05 12:41:43','1'),
 (73,1,2,NULL,3,4,'','2020-04-05 13:35:02','1'),
 (74,1,NULL,1,4,4,'','2020-04-06 12:42:50','1'),
 (75,1,NULL,3,NULL,NULL,'','2020-04-06 12:47:05','1'),
 (76,1,NULL,3,NULL,NULL,'','2020-04-06 12:50:27','admin'),
 (77,1,3,NULL,4,5,'','2020-04-06 12:51:53','admin'),
 (78,4,9,NULL,9,10,'','2020-04-06 20:42:05','admin'),
 (79,1,NULL,3,NULL,NULL,'','2020-04-07 20:24:28','admin'),
 (80,1,NULL,3,NULL,NULL,'','2020-04-07 20:34:14','admin'),
 (81,1,NULL,2,NULL,NULL,'','2020-04-07 20:34:23','admin'),
 (82,1,NULL,2,NULL,NULL,'','2020-04-07 20:35:01','admin'),
 (83,1,NULL,3,NULL,NULL,'','2020-04-07 20:41:30','admin'),
 (84,1,NULL,3,NULL,NULL,'','2020-04-07 20:42:06','admin'),
 (85,1,NULL,2,NULL,NULL,'','2020-04-07 20:43:31','admin'),
 (86,1,NULL,2,NULL,NULL,'','2020-04-07 20:45:15','admin'),
 (87,1,NULL,2,NULL,NULL,'','2020-04-08 13:14:17','admin'),
 (88,1,NULL,3,NULL,NULL,'','2020-04-08 13:14:42','admin'),
 (89,1,NULL,1,5,3,'','2020-04-08 13:16:05','admin'),
 (90,1,2,NULL,3,4,'','2020-04-08 13:16:16','admin'),
 (91,1,NULL,1,4,3,'','2020-04-08 13:16:52','admin'),
 (92,1,2,NULL,3,4,'','2020-04-08 13:17:08','admin'),
 (93,2,NULL,1,4,3,'','2020-04-08 13:18:17','admin'),
 (94,2,2,NULL,3,4,'','2020-04-08 13:18:25','admin');
/*!40000 ALTER TABLE `process_logbook` ENABLE KEYS */;


--
-- Definition of table `status_group`
--

DROP TABLE IF EXISTS `status_group`;
CREATE TABLE `status_group` (
  `idstatus_group` int(11) NOT NULL AUTO_INCREMENT,
  `ct_status_idct_status` int(11) NOT NULL,
  `access_group_idaccess_group` int(11) NOT NULL,
  PRIMARY KEY (`idstatus_group`),
  KEY `fk_status_group_ct_status1_idx` (`ct_status_idct_status`),
  KEY `fk_status_group_access_group1_idx` (`access_group_idaccess_group`),
  CONSTRAINT `fk_status_group_access_group1` FOREIGN KEY (`access_group_idaccess_group`) REFERENCES `access_group` (`idaccess_group`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_status_group_ct_status1` FOREIGN KEY (`ct_status_idct_status`) REFERENCES `ct_status` (`idct_status`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `status_group`
--

/*!40000 ALTER TABLE `status_group` DISABLE KEYS */;
INSERT INTO `status_group` (`idstatus_group`,`ct_status_idct_status`,`access_group_idaccess_group`) VALUES 
 (1,1,4),
 (2,2,4),
 (3,3,4),
 (4,4,4),
 (5,5,4),
 (6,6,4),
 (7,7,4),
 (8,8,5),
 (9,9,5),
 (10,10,5),
 (11,11,5),
 (12,12,5),
 (13,13,5),
 (14,14,5),
 (15,1,1),
 (16,8,6),
 (17,9,6),
 (18,10,8),
 (19,12,8),
 (20,13,8),
 (21,11,7);
/*!40000 ALTER TABLE `status_group` ENABLE KEYS */;


--
-- Definition of table `status_proceeding`
--

DROP TABLE IF EXISTS `status_proceeding`;
CREATE TABLE `status_proceeding` (
  `idstatus_proceeding` int(11) NOT NULL AUTO_INCREMENT,
  `ct_status_idct_status` int(11) NOT NULL,
  `ct_proceeding_idct_proceeding` int(11) NOT NULL,
  PRIMARY KEY (`idstatus_proceeding`),
  KEY `fk_status_proceeding_ct_status1_idx` (`ct_status_idct_status`),
  KEY `fk_status_proceeding_ct_proceeding1_idx` (`ct_proceeding_idct_proceeding`),
  CONSTRAINT `fk_status_proceeding_ct_proceeding1` FOREIGN KEY (`ct_proceeding_idct_proceeding`) REFERENCES `ct_proceeding` (`idct_proceeding`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_status_proceeding_ct_status1` FOREIGN KEY (`ct_status_idct_status`) REFERENCES `ct_status` (`idct_status`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `status_proceeding`
--

/*!40000 ALTER TABLE `status_proceeding` DISABLE KEYS */;
INSERT INTO `status_proceeding` (`idstatus_proceeding`,`ct_status_idct_status`,`ct_proceeding_idct_proceeding`) VALUES 
 (1,1,1),
 (2,2,4),
 (3,3,2),
 (4,4,3),
 (5,5,5),
 (6,6,6),
 (11,8,15),
 (12,9,7),
 (13,9,8),
 (14,9,9),
 (15,10,10),
 (16,10,11),
 (17,11,12),
 (18,12,13),
 (19,13,14);
/*!40000 ALTER TABLE `status_proceeding` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `superCode` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`superCode`,`description`) VALUES 
 (1,'EX04_STATUS','Expedient EX04 Status'),
 (2,'EX04_TASK','Expedient EX04 proceeding'),
 (3,'EX04_UTIL','Expedient EX04 Utilities'),
 (4,'LANGUAGE','Language of interface'),
 (5,'EX01_STATUS','Expedient EX01 Status'),
 (6,'EX01_TASK','Expedient EX01 proceeding'),
 (7,'EX01_UTIL','Expedient EX01 Utilities'),
 (8,'ALERT_CLASS','Alert Classes'),
 (9,'ALERT_SITUATION','Alerts status'),
 (10,'DOCUMENT_EE','Document Entry or Exit'),
 (11,'EX01_EXPENSE','Tipo de Gastos');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `user`
--

DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `iduser` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `NameAndSurname` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `chief_iduser` int(11) DEFAULT NULL,
  `active` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  `lastProcessWorked` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`iduser`),
  KEY `fk_user_user1_idx` (`chief_iduser`),
  CONSTRAINT `fk_user_user1` FOREIGN KEY (`chief_iduser`) REFERENCES `user` (`iduser`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `user`
--

/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`iduser`,`login`,`password`,`NameAndSurname`,`email`,`chief_iduser`,`active`,`reset_token`,`reset_date`,`lastProcessWorked`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Fernando Humanes','info@fhumanes.com',1,'1',NULL,NULL,1),
 (2,'user1','24c9e15e52afc47c225b757e7bee1f9d','User1','info@fhumanes.com',4,'1',NULL,NULL,2),
 (3,'user2','7e58d63b60197ceb55a1c487989a3720','User2','info@fhumanes.com',4,'1',NULL,NULL,1),
 (4,'boss1','c333ba0d6e308bdb32ce3f2785301ae8','Boos 1','info@fhumanes.com',1,'1',NULL,NULL,1),
 (5,'rrhh1','a662d3f38582d19910487bbcc4e5ebdb','RRHH 1','info@fhumanes.com',4,'1',NULL,NULL,2),
 (6,'accounting1','9fe53c4adeac1691021662f165c72eea','Accounting 1','info@fhumanes.com',4,'1',NULL,NULL,2);
/*!40000 ALTER TABLE `user` ENABLE KEYS */;


--
-- Definition of table `user_group`
--

DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group` (
  `iduser_group` int(11) NOT NULL AUTO_INCREMENT,
  `user_iduser` int(11) NOT NULL,
  `access_group_idaccess_group` int(11) NOT NULL,
  PRIMARY KEY (`iduser_group`),
  KEY `fk_user_group_user1_idx` (`user_iduser`),
  KEY `fk_user_group_access_group1_idx` (`access_group_idaccess_group`),
  CONSTRAINT `fk_user_group_access_group1` FOREIGN KEY (`access_group_idaccess_group`) REFERENCES `access_group` (`idaccess_group`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_user_group_user1` FOREIGN KEY (`user_iduser`) REFERENCES `user` (`iduser`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `user_group`
--

/*!40000 ALTER TABLE `user_group` DISABLE KEYS */;
INSERT INTO `user_group` (`iduser_group`,`user_iduser`,`access_group_idaccess_group`) VALUES 
 (1,1,4),
 (2,1,1),
 (3,1,5),
 (4,2,1),
 (5,3,1),
 (6,4,1),
 (7,2,6),
 (8,3,6),
 (9,4,6),
 (10,5,7),
 (11,5,2),
 (12,6,8),
 (13,6,3);
/*!40000 ALTER TABLE `user_group` ENABLE KEYS */;


--
-- Definition of table `utility_group`
--

DROP TABLE IF EXISTS `utility_group`;
CREATE TABLE `utility_group` (
  `idutility_group` int(11) NOT NULL AUTO_INCREMENT,
  `ct_utility_idct_utility` int(11) NOT NULL,
  `access_group_idaccess_group` int(11) NOT NULL,
  PRIMARY KEY (`idutility_group`),
  KEY `fk_utility_group_ct_utility1_idx` (`ct_utility_idct_utility`),
  KEY `fk_utility_group_access_group1_idx` (`access_group_idaccess_group`),
  CONSTRAINT `fk_utility_group_access_group1` FOREIGN KEY (`access_group_idaccess_group`) REFERENCES `access_group` (`idaccess_group`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_utility_group_ct_utility1` FOREIGN KEY (`ct_utility_idct_utility`) REFERENCES `ct_utility` (`idct_utility`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utility_group`
--

/*!40000 ALTER TABLE `utility_group` DISABLE KEYS */;
INSERT INTO `utility_group` (`idutility_group`,`ct_utility_idct_utility`,`access_group_idaccess_group`) VALUES 
 (4,1,4),
 (5,2,4),
 (6,3,4),
 (7,4,5),
 (8,4,7);
/*!40000 ALTER TABLE `utility_group` ENABLE KEYS */;


--
-- Definition of table `wf2_audit`
--

DROP TABLE IF EXISTS `wf2_audit`;
CREATE TABLE `wf2_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=880 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wf2_audit`
--

/*!40000 ALTER TABLE `wf2_audit` DISABLE KEYS */;
INSERT INTO `wf2_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (1,'2020-01-11 21:16:03','::1','admin','user','failed login',''),
 (2,'2020-01-11 21:16:12','::1','admin','user','login',''),
 (3,'2020-01-11 21:25:24','::1','admin','user','failed login',''),
 (4,'2020-01-11 21:25:32','::1','admin','user','login',''),
 (5,'2020-01-11 21:27:19','::1','admin','user','logout',''),
 (6,'2020-01-11 21:27:26','::1','admin','user','login',''),
 (7,'2020-01-11 21:27:51','::1','admin','user','logout',''),
 (8,'2020-01-12 20:42:41','::1','admin','user','login',''),
 (9,'2020-01-12 20:43:11','::1','admin','user','logout',''),
 (10,'2020-01-12 20:54:07','::1','admin','user','login',''),
 (11,'2020-01-12 21:02:43','::1','admin','user','logout',''),
 (12,'2020-01-12 22:38:56','::1','admin','user','login',''),
 (13,'2020-01-12 22:40:13','::1','admin','user','logout',''),
 (14,'2020-01-17 17:27:53','::1','admin','user','login',''),
 (15,'2020-01-17 17:29:45','::1','admin','process','add','---Keys\r\nidprocess : 1\r\n---Fields\r\ncode [new]: EX04\r\ntitle [new]: Cash advances\r\nsuperCodeStatus [new]: EX04_STATUS\r\nsuperCodeProceeding [new]: EX04_TASK\r\nsuperCodeUtility [new]: EX04_UTIL\r\n'),
 (16,'2020-01-17 17:33:43','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 1\r\n---Fields\r\ndescription [new]: Expedient EX04 Status\r\nsuperCode [new]: EX04_STATUS\r\n'),
 (17,'2020-01-17 17:39:02','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 2\r\n---Fields\r\nsuperCode [new]: EX04_TASK\r\ndescription [new]: Expedient EX04 proceeding\r\n'),
 (18,'2020-01-17 17:39:29','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 3\r\n---Fields\r\nsuperCode [new]: EX04_UTIL\r\ndescription [new]: Expedient EX04 utilitys\r\n'),
 (19,'2020-01-17 17:42:35','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 4\r\n---Fields\r\nsuperCode [new]: LANGUAGE\r\ndescription [new]: Language of interface\r\n'),
 (20,'2020-01-17 17:48:02','::1','admin','catalog','add','---Keys\r\nidcatalog : 1\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\ndescription [new]: Inglés\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: English\r\n'),
 (21,'2020-01-17 17:48:22','::1','admin','catalog','add','---Keys\r\nidcatalog : 2\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 4\r\ndescription [new]: Español\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Spanish\r\n'),
 (22,'2020-01-17 17:53:44','::1','admin','user','login',''),
 (23,'2020-01-17 17:54:51','::1','admin','catalog','add','---Keys\r\nidcatalog : 3\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ndescription [new]: Pte. Revisión Jefe inmediato\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Pte. Revisión Jefe inmediato\r\n'),
 (24,'2020-01-17 17:55:03','::1','admin','catalog','edit','---Keys\r\nidcatalog : 3\r\n---Fields\r\ncatalogNum [old]: 0\r\ncatalogNum [new]: 1\r\n'),
 (25,'2020-01-17 17:56:37','::1','admin','catalog','add','---Keys\r\nidcatalog : 4\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ndescription [new]: Pte. denegación\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Pte. denegación\r\n'),
 (26,'2020-01-17 17:57:45','::1','admin','catalog','add','---Keys\r\nidcatalog : 5\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Pte. revisión de RRHH\r\ndescription [new]: Pte. revisión de RRHH\r\n'),
 (27,'2020-01-17 17:58:16','::1','admin','catalog','add','---Keys\r\nidcatalog : 6\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Pte. aviso de pago\r\ndescription [new]: Pte. aviso de pago\r\n'),
 (28,'2020-01-17 17:58:44','::1','admin','catalog','add','---Keys\r\nidcatalog : 7\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Pte. de Pago\r\ndescription [new]: Pte. de Pago\r\n'),
 (29,'2020-01-17 17:59:09','::1','admin','catalog','add','---Keys\r\nidcatalog : 8\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Pte. descuento en nómina\r\ndescription [new]: Pte. descuento en nómina\r\n'),
 (30,'2020-01-17 17:59:44','::1','admin','catalog','add','---Keys\r\nidcatalog : 9\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Archivado / Finalizado\r\ndescription [new]: Archivado / Finalizado\r\n'),
 (31,'2020-01-17 18:00:37','::1','admin','catalog','add','---Keys\r\nidcatalog : 10\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: English\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Pending review Immediate boss\r\ndescription [new]: Pendiente de revisión Jefe inmediato\r\n'),
 (32,'2020-01-17 18:00:46','::1','admin','catalog','edit','---Keys\r\nidcatalog : 10\r\n---Fields\r\ncatalogNum [old]: 0\r\ncatalogNum [new]: 1\r\n'),
 (33,'2020-01-17 18:01:28','::1','admin','catalog','add','---Keys\r\nidcatalog : 11\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Pending Denial\r\ndescription [new]: Pendiente denegación\r\n'),
 (34,'2020-01-17 18:02:09','::1','admin','catalog','add','---Keys\r\nidcatalog : 12\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Pending HR review\r\ndescription [new]: Pendiente revisión de RRHH\r\n'),
 (35,'2020-01-17 18:02:45','::1','admin','catalog','add','---Keys\r\nidcatalog : 13\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: English\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Pending payment notice\r\ndescription [new]: Pendiente aviso de pago\r\n'),
 (36,'2020-01-17 18:03:31','::1','admin','catalog','add','---Keys\r\nidcatalog : 14\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Outstanding\r\ndescription [new]: Pendiente de Pago\r\n'),
 (37,'2020-01-17 18:04:06','::1','admin','catalog','add','---Keys\r\nidcatalog : 15\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: English\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Pending payroll discount\r\ndescription [new]: Pendiente descuento en nómina\r\n'),
 (38,'2020-01-17 18:04:43','::1','admin','catalog','add','---Keys\r\nidcatalog : 16\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 1\r\nlanguage [new]: English\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Filed / Finished\r\ndescription [new]: Archivado / Finalizado\r\n'),
 (39,'2020-01-17 18:06:35','::1','admin','catalog','add','---Keys\r\nidcatalog : 17\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Revisión\r\n'),
 (40,'2020-01-17 18:07:00','::1','admin','catalog','add','---Keys\r\nidcatalog : 18\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Revisión RRHH\r\n'),
 (41,'2020-01-17 18:07:18','::1','admin','catalog','add','---Keys\r\nidcatalog : 19\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Avisar del Pago\r\n'),
 (42,'2020-01-17 18:07:45','::1','admin','catalog','add','---Keys\r\nidcatalog : 20\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Denegación\r\n'),
 (43,'2020-01-17 18:08:06','::1','admin','catalog','add','---Keys\r\nidcatalog : 21\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Pago del Anticipo\r\n'),
 (44,'2020-01-17 18:08:26','::1','admin','catalog','add','---Keys\r\nidcatalog : 22\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Descuento en nómina\r\n'),
 (45,'2020-01-17 18:08:55','::1','admin','catalog','add','---Keys\r\nidcatalog : 23\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Revision\r\n'),
 (46,'2020-01-17 18:09:22','::1','admin','catalog','add','---Keys\r\nidcatalog : 24\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: HR Review\r\n'),
 (47,'2020-01-17 18:09:46','::1','admin','catalog','add','---Keys\r\nidcatalog : 25\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Notice of Payment\r\n'),
 (48,'2020-01-17 18:10:10','::1','admin','catalog','add','---Keys\r\nidcatalog : 26\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Denial\r\n'),
 (49,'2020-01-17 18:10:39','::1','admin','catalog','add','---Keys\r\nidcatalog : 27\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Advance Payment\r\n'),
 (50,'2020-01-17 18:11:10','::1','admin','catalog','add','---Keys\r\nidcatalog : 28\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 2\r\nlanguage [new]: English\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Payroll Discount\r\n'),
 (51,'2020-01-17 18:11:29','::1','admin','catalog','edit','---Keys\r\nidcatalog : 20\r\n---Fields\r\nlanguage [old]: English\r\nlanguage [new]: Spanish\r\n'),
 (52,'2020-01-17 18:11:41','::1','admin','catalog','edit','---Keys\r\nidcatalog : 21\r\n---Fields\r\nlanguage [old]: English\r\nlanguage [new]: Spanish\r\n'),
 (53,'2020-01-17 18:13:13','::1','admin','catalog','add','---Keys\r\nidcatalog : 29\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 3\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Modificar Expediente\r\ndescription [new]: Modificar Expediente\r\n'),
 (54,'2020-01-17 18:14:12','::1','admin','catalog','add','---Keys\r\nidcatalog : 30\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 3\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Listado de expdientes\r\ndescription [new]: Listado de expdientes\r\n'),
 (55,'2020-01-17 18:14:37','::1','admin','catalog','add','---Keys\r\nidcatalog : 31\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 3\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Impresión del Expediente\r\ndescription [new]: Impresión del Expediente\r\n'),
 (56,'2020-01-17 18:15:12','::1','admin','catalog','add','---Keys\r\nidcatalog : 32\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 3\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Updated Expedient\r\n'),
 (57,'2020-01-17 18:15:47','::1','admin','catalog','add','---Keys\r\nidcatalog : 33\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 3\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: List of records\r\n'),
 (58,'2020-01-17 18:16:24','::1','admin','catalog','add','---Keys\r\nidcatalog : 34\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 3\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Expedient Printing\r\n'),
 (59,'2020-01-17 18:28:27','::1','admin','access_group','add','---Keys\r\nidaccess_group : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncode [new]: Employee\r\ntitle [new]: Any Company Employee\r\ncanAddExpedient [new]: 1\r\ncanEditExpedient [new]: 1\r\ncanViewExpedient [new]: 1\r\n'),
 (60,'2020-01-17 18:32:11','::1','admin','access_group','add','---Keys\r\nidaccess_group : 2\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncode [new]: RRHH\r\ntitle [new]: Human Resources\r\ncanViewExpedient [new]: 1\r\n'),
 (61,'2020-01-17 18:33:05','::1','admin','access_group','add','---Keys\r\nidaccess_group : 3\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncode [new]: Payer\r\ntitle [new]: Cash / Payer\r\ncanViewExpedient [new]: 1\r\n'),
 (62,'2020-01-17 18:33:24','::1','admin','access_group','edit','---Keys\r\nidaccess_group : 1\r\n---Fields\r\ncanEditExpedient [old]: 1\r\ncanEditExpedient [new]: 0\r\n'),
 (63,'2020-01-17 18:34:21','::1','admin','access_group','add','---Keys\r\nidaccess_group : 4\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncode [new]: Admin\r\ntitle [new]: Administrator and Test\r\ncanAddExpedient [new]: 1\r\ncanEditExpedient [new]: 1\r\ncanViewExpedient [new]: 1\r\n'),
 (64,'2020-01-17 18:51:22','::1','admin','user_group','add','---Keys\r\niduser_group : 1\r\n---Fields\r\nuser_iduser [new]: 1\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (65,'2020-01-17 18:53:21','::1','admin','user_group','add','---Keys\r\niduser_group : 2\r\n---Fields\r\nuser_iduser [new]: 1\r\naccess_group_idaccess_group [new]: 1\r\n'),
 (66,'2020-01-19 13:45:11','::1','admin','user','login',''),
 (67,'2020-01-19 13:48:39','::1','admin','user','logout',''),
 (68,'2020-01-19 13:48:44','::1','admin','user','login',''),
 (69,'2020-01-19 13:50:44','::1','admin','user','logout',''),
 (70,'2020-01-19 13:50:50','::1','admin','user','login',''),
 (71,'2020-01-19 13:54:51','::1','admin','user','logout',''),
 (72,'2020-01-19 13:54:56','::1','admin','user','login',''),
 (73,'2020-01-19 13:55:06','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (74,'2020-01-19 14:05:13','::1','admin','user','logout',''),
 (75,'2020-01-19 14:05:20','::1','admin','user','login',''),
 (76,'2020-01-19 14:05:27','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (77,'2020-01-19 14:24:48','::1','admin','user','logout',''),
 (78,'2020-01-19 14:24:55','::1','admin','user','login',''),
 (79,'2020-01-19 14:24:58','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (80,'2020-01-19 14:26:55','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (81,'2020-01-22 21:08:14','::1','admin','user','login',''),
 (82,'2020-01-22 21:08:17','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (83,'2020-01-22 21:08:49','::1','admin','ct_utility','add','---Keys\r\nidct_utility : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 1\r\nimportanceWeight [new]: 1\r\nurlUtility [new]: Listado\r\n'),
 (84,'2020-01-22 21:09:05','::1','admin','utility_group','add','---Keys\r\nidutility_group : 1\r\n---Fields\r\nct_utility_idct_utility [new]: 1\r\naccess_group_idaccess_group [new]: 1\r\n'),
 (85,'2020-01-22 21:09:13','::1','admin','utility_group','add','---Keys\r\nidutility_group : 2\r\n---Fields\r\nct_utility_idct_utility [new]: 1\r\naccess_group_idaccess_group [new]: 2\r\n'),
 (86,'2020-01-22 21:09:20','::1','admin','utility_group','add','---Keys\r\nidutility_group : 3\r\n---Fields\r\nct_utility_idct_utility [new]: 1\r\naccess_group_idaccess_group [new]: 3\r\n'),
 (87,'2020-01-22 21:09:26','::1','admin','utility_group','add','---Keys\r\nidutility_group : 4\r\n---Fields\r\nct_utility_idct_utility [new]: 1\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (88,'2020-01-23 19:41:46','::1','admin','user','login',''),
 (89,'2020-01-23 19:41:48','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (90,'2020-01-23 19:43:37','::1','admin','process','edit','---Keys\r\nidprocess : 1\r\n---Fields\r\nurlAdd [old]: \r\nurlAdd [new]: EX04_expedient_add.php\r\nurlEdit [old]: \r\nurlEdit [new]: EX04_expedient_edit.php\r\nurlView [old]: \r\nurlView [new]: EX04_expedient_view.php\r\n'),
 (91,'2020-01-24 22:35:09','::1','admin','user','logout',''),
 (92,'2020-02-02 13:34:09','::1','admin','user','login',''),
 (93,'2020-02-02 13:36:28','::1','admin','user','login',''),
 (94,'2020-02-02 13:38:33','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (95,'2020-02-02 13:49:54','::1','admin','ct_status','add','---Keys\r\nidct_status : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 1\r\n'),
 (96,'2020-02-02 13:50:35','::1','admin','ct_status','add','---Keys\r\nidct_status : 2\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 2\r\n'),
 (97,'2020-02-02 13:50:59','::1','admin','catalog','edit','---Keys\r\nidcatalog : 11\r\n---Fields\r\nlanguage [old]: Spanish\r\nlanguage [new]: English\r\n'),
 (98,'2020-02-02 13:51:29','::1','admin','ct_status','add','---Keys\r\nidct_status : 3\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 3\r\n'),
 (99,'2020-02-02 13:51:37','::1','admin','ct_status','add','---Keys\r\nidct_status : 4\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 4\r\n'),
 (100,'2020-02-02 13:51:48','::1','admin','ct_status','add','---Keys\r\nidct_status : 5\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 5\r\n'),
 (101,'2020-02-02 13:52:08','::1','admin','catalog','edit','---Keys\r\nidcatalog : 14\r\n---Fields\r\nlanguage [old]: Spanish\r\nlanguage [new]: English\r\n'),
 (102,'2020-02-02 13:52:33','::1','admin','ct_status','add','---Keys\r\nidct_status : 6\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 6\r\n'),
 (103,'2020-02-02 13:52:40','::1','admin','ct_status','add','---Keys\r\nidct_status : 7\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 7\r\nisTheEnd [new]: 1\r\n'),
 (104,'2020-02-02 13:59:48','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 1\r\nimportanceWeight [new]: 1\r\nurlProceeding [new]: vv\r\n'),
 (105,'2020-02-02 14:00:18','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 2\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 2\r\nimportanceWeight [new]: 2\r\nurlProceeding [new]: www\r\n'),
 (106,'2020-02-02 14:01:34','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 3\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 3\r\nimportanceWeight [new]: 3\r\nurlProceeding [new]: www\r\n'),
 (107,'2020-02-02 14:01:48','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 4\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 4\r\nimportanceWeight [new]: 4\r\nurlProceeding [new]: ww\r\n'),
 (108,'2020-02-02 14:01:59','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 5\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 5\r\nimportanceWeight [new]: 5\r\nurlProceeding [new]: ww\r\n'),
 (109,'2020-02-02 14:02:11','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 6\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 6\r\nimportanceWeight [new]: 6\r\nurlProceeding [new]: ww\r\n'),
 (110,'2020-02-02 19:24:02','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 1\r\n---Fields\r\nct_status_idct_status [new]: 1\r\nct_proceeding_idct_proceeding [new]: 1\r\n'),
 (111,'2020-02-02 19:45:14','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 2\r\n---Fields\r\nct_status_idct_status [new]: 2\r\nct_proceeding_idct_proceeding [new]: 4\r\n'),
 (112,'2020-02-02 19:45:35','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 3\r\n---Fields\r\nct_status_idct_status [new]: 3\r\nct_proceeding_idct_proceeding [new]: 2\r\n'),
 (113,'2020-02-02 19:45:48','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 4\r\n---Fields\r\nct_status_idct_status [new]: 4\r\nct_proceeding_idct_proceeding [new]: 3\r\n'),
 (114,'2020-02-02 19:46:11','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 5\r\n---Fields\r\nct_status_idct_status [new]: 5\r\nct_proceeding_idct_proceeding [new]: 5\r\n'),
 (115,'2020-02-02 19:46:42','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 6\r\n---Fields\r\nct_status_idct_status [new]: 6\r\nct_proceeding_idct_proceeding [new]: 6\r\n'),
 (116,'2020-02-02 20:06:44','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 1\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 1\r\nct_status_idct_status [new]: 2\r\n'),
 (117,'2020-02-02 20:07:00','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 2\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 1\r\nct_status_idct_status [new]: 3\r\n'),
 (118,'2020-02-02 20:07:39','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 3\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 2\r\nct_status_idct_status [new]: 4\r\n'),
 (119,'2020-02-02 20:07:51','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 4\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 2\r\nct_status_idct_status [new]: 2\r\n'),
 (120,'2020-02-02 20:08:19','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 5\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 3\r\nct_status_idct_status [new]: 5\r\n'),
 (121,'2020-02-02 20:08:28','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 6\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 4\r\nct_status_idct_status [new]: 7\r\n'),
 (122,'2020-02-02 20:08:41','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 7\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 5\r\nct_status_idct_status [new]: 6\r\n'),
 (123,'2020-02-02 20:08:53','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 8\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 6\r\nct_status_idct_status [new]: 7\r\n'),
 (124,'2020-02-02 20:18:17','::1','admin','ct_utility','edit','---Keys\r\nidct_utility : 1\r\n---Fields\r\nurlUtility [old]: Listado\r\nurlUtility [new]: update\r\n'),
 (125,'2020-02-02 20:18:34','::1','admin','ct_utility','add','---Keys\r\nidct_utility : 2\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 2\r\nimportanceWeight [new]: 2\r\nurlUtility [new]: list\r\n'),
 (126,'2020-02-02 20:18:46','::1','admin','ct_utility','add','---Keys\r\nidct_utility : 3\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ncatalogNum [new]: 3\r\nimportanceWeight [new]: 3\r\nurlUtility [new]: print\r\n'),
 (127,'2020-02-02 21:02:23','::1','admin','config','add','---Fields\r\nname [new]: FILE_CODE_REPORT\r\nvalue [new]: files/code_report\r\n'),
 (128,'2020-02-02 21:03:03','::1','admin','config','add','---Fields\r\nname [new]: FILE_CONDITION_REPORT\r\nvalue [new]: files/conditions_report\r\n'),
 (129,'2020-02-02 21:17:34','::1','admin','user','logout',''),
 (130,'2020-02-03 11:08:34','::1','admin','user','login',''),
 (131,'2020-02-03 11:08:36','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (132,'2020-02-03 11:11:43','::1','admin','user','logout',''),
 (133,'2020-02-03 12:48:41','::1','admin','user','login',''),
 (134,'2020-02-03 12:48:44','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (135,'2020-02-03 13:05:00','::1','admin','ct_report','add','---Keys\r\nidct_report : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_proceeding_idct_proceeding [new]: 2\r\ntitle [new]: Primer documento Word\r\nisPHPWord [new]: 1\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo 1_8mrv36lf.docx\",\"usrName\":\"plantilla ejemplo 1.docx\",\"size\":15152,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo 1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nconditionFile [new]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_zbo96wyg.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":146,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [new]: 2020-02-03 13:03:59\r\nlastUpdateUser [new]: admin\r\n'),
 (136,'2020-02-03 13:16:19','::1','admin','config','add','---Fields\r\nname [new]: FILE_TEMPLATE\r\nvalue [new]: files/templates\r\n'),
 (137,'2020-02-03 13:25:43','::1','admin','config','edit','---Keys\r\nidconfig : 3\r\n---Fields\r\nvalue [old]: files/templates\r\nvalue [new]: files/template\r\n'),
 (138,'2020-02-03 20:35:49','::1','admin','user','logout',''),
 (139,'2020-02-07 19:58:19','::1','admin','user','login',''),
 (140,'2020-02-07 19:58:21','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (141,'2020-02-07 20:17:55','::1','admin','user','edit','---Keys\r\niduser : 1\r\n'),
 (142,'2020-02-07 20:47:02','::1','admin','ct_templates','add','---Keys\r\nidct_templates : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\ntitle [new]: Example of Template\r\nfileContent [new]: [{\"name\":\"files\\/template\\/plantilla ejemplo 1_fashkepc.docx\",\"usrName\":\"plantilla ejemplo 1.docx\",\"size\":15152,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo 1.docx,!:sStrEnd\"}]\r\nlastUpdateDate [new]: 2020-02-07 20:46:05\r\nlastUpdateUser [new]: admin\r\n'),
 (143,'2020-02-07 21:02:33','::1','admin','utility_group','delete','---Keys\r\nidutility_group : 1\r\n---Fields\r\nct_utility_idct_utility [old]: 1\r\naccess_group_idaccess_group [old]: 1\r\n'),
 (144,'2020-02-07 21:02:33','::1','admin','utility_group','delete','---Keys\r\nidutility_group : 2\r\n---Fields\r\nct_utility_idct_utility [old]: 1\r\naccess_group_idaccess_group [old]: 2\r\n'),
 (145,'2020-02-07 21:02:33','::1','admin','utility_group','delete','---Keys\r\nidutility_group : 3\r\n---Fields\r\nct_utility_idct_utility [old]: 1\r\naccess_group_idaccess_group [old]: 3\r\n'),
 (146,'2020-02-07 21:04:12','::1','admin','utility_group','add','---Keys\r\nidutility_group : 5\r\n---Fields\r\nct_utility_idct_utility [new]: 2\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (147,'2020-02-07 21:04:21','::1','admin','utility_group','add','---Keys\r\nidutility_group : 6\r\n---Fields\r\nct_utility_idct_utility [new]: 3\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (148,'2020-02-07 21:12:47','::1','admin','status_group','add','---Keys\r\nidstatus_group : 1\r\n---Fields\r\nct_status_idct_status [new]: 1\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (149,'2020-02-07 21:13:02','::1','admin','status_group','add','---Keys\r\nidstatus_group : 2\r\n---Fields\r\nct_status_idct_status [new]: 2\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (150,'2020-02-07 21:13:10','::1','admin','status_group','add','---Keys\r\nidstatus_group : 3\r\n---Fields\r\nct_status_idct_status [new]: 3\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (151,'2020-02-07 21:13:17','::1','admin','status_group','add','---Keys\r\nidstatus_group : 4\r\n---Fields\r\nct_status_idct_status [new]: 4\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (152,'2020-02-07 21:13:28','::1','admin','status_group','add','---Keys\r\nidstatus_group : 5\r\n---Fields\r\nct_status_idct_status [new]: 5\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (153,'2020-02-07 21:13:36','::1','admin','status_group','add','---Keys\r\nidstatus_group : 6\r\n---Fields\r\nct_status_idct_status [new]: 6\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (154,'2020-02-07 21:13:44','::1','admin','status_group','add','---Keys\r\nidstatus_group : 7\r\n---Fields\r\nct_status_idct_status [new]: 7\r\naccess_group_idaccess_group [new]: 4\r\n'),
 (155,'2020-02-08 11:15:52','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (156,'2020-02-09 20:06:02','::1','admin','user','login',''),
 (157,'2020-02-09 20:08:05','::1','admin','process','add','---Keys\r\nidprocess : 2\r\n---Fields\r\ncode [new]: EX01\r\ntitle [new]: Travel Expenses settlement\r\nsuperCodeStatus [new]: EX01_STATUS\r\nsuperCodeProceeding [new]: EX01_TASK\r\nsuperCodeUtility [new]: EX01_UTIL\r\nurlAdd [new]: DEDE\r\nurlEdit [new]: DEDEDE\r\nurlView [new]: DEDDE\r\n'),
 (158,'2020-02-09 20:08:50','::1','admin','access_group','add','---Keys\r\nidaccess_group : 5\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncode [new]: Admin\r\ntitle [new]: Administrator\r\ncanAddExpedient [new]: 1\r\ncanEditExpedient [new]: 1\r\ncanViewExpedient [new]: 1\r\n'),
 (159,'2020-02-09 20:09:04','::1','admin','user_group','add','---Keys\r\niduser_group : 3\r\n---Fields\r\nuser_iduser [new]: 1\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (160,'2020-02-09 20:10:20','::1','admin','user','logout',''),
 (161,'2020-02-09 20:10:28','::1','admin','user','login',''),
 (162,'2020-02-09 20:18:02','::1','admin','user','logout',''),
 (163,'2020-02-09 20:18:08','::1','admin','user','login',''),
 (164,'2020-02-09 20:20:17','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (165,'2020-02-09 20:21:32','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 5\r\n---Fields\r\nsuperCode [new]: EX01_STATUS\r\ndescription [new]: Expedient EX01 Status\r\n'),
 (166,'2020-02-09 20:22:08','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 6\r\n---Fields\r\nsuperCode [new]: EX01_TASK\r\ndescription [new]: Expedient EX01 Proceesing\r\n'),
 (167,'2020-02-09 20:22:24','::1','admin','super_catalog','edit','---Keys\r\nidsuper_catalog : 6\r\n---Fields\r\ndescription [old]: Expedient EX01 Proceesing\r\ndescription [new]: Expedient EX01 proceeding\r\n'),
 (168,'2020-02-09 20:22:58','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 7\r\n---Fields\r\nsuperCode [new]: EX01_UTIL\r\ndescription [new]: Expedient EX01 Utilities\r\n'),
 (169,'2020-02-09 20:23:12','::1','admin','super_catalog','edit','---Keys\r\nidsuper_catalog : 3\r\n---Fields\r\ndescription [old]: Expedient EX04 utilitys\r\ndescription [new]: Expedient EX04 Utilities\r\n'),
 (170,'2020-02-09 20:24:33','::1','admin','catalog','add','---Keys\r\nidcatalog : 35\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Pte. Completar información\r\n'),
 (171,'2020-02-09 20:24:54','::1','admin','catalog','add','---Keys\r\nidcatalog : 36\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Pte. Revisión de gastos\r\n'),
 (172,'2020-02-09 20:25:23','::1','admin','catalog','add','---Keys\r\nidcatalog : 37\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Pte. Revisar por Contabiliad\r\n'),
 (173,'2020-02-09 20:25:47','::1','admin','catalog','add','---Keys\r\nidcatalog : 38\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Pte. Aplicar a nómina\r\n'),
 (174,'2020-02-09 20:26:01','::1','admin','catalog','add','---Keys\r\nidcatalog : 39\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Finalizar\r\n'),
 (175,'2020-02-09 20:26:16','::1','admin','catalog','add','---Keys\r\nidcatalog : 40\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Arvhivado\r\n'),
 (176,'2020-02-09 20:26:31','::1','admin','catalog','add','---Keys\r\nidcatalog : 41\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Fin\r\n'),
 (177,'2020-02-09 20:27:26','::1','admin','catalog','add','---Keys\r\nidcatalog : 42\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Pending Complete Information\r\n'),
 (178,'2020-02-09 20:28:14','::1','admin','catalog','add','---Keys\r\nidcatalog : 43\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Pending Expediture Review\r\n'),
 (179,'2020-02-09 20:28:43','::1','admin','catalog','add','---Keys\r\nidcatalog : 44\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Pending Accounting Review\r\n'),
 (180,'2020-02-09 20:30:17','::1','admin','catalog','add','---Keys\r\nidcatalog : 45\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Pending to apply on payroll\r\n'),
 (181,'2020-02-09 20:30:33','::1','admin','catalog','add','---Keys\r\nidcatalog : 46\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Finalize\r\n'),
 (182,'2020-02-09 20:30:51','::1','admin','catalog','add','---Keys\r\nidcatalog : 47\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Archived\r\n'),
 (183,'2020-02-09 20:31:05','::1','admin','catalog','add','---Keys\r\nidcatalog : 48\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 5\r\nlanguage [new]: English\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: The End\r\n'),
 (184,'2020-02-09 20:32:20','::1','admin','catalog','add','---Keys\r\nidcatalog : 49\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Completar información\r\n'),
 (185,'2020-02-09 20:32:40','::1','admin','catalog','add','---Keys\r\nidcatalog : 50\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Denegar petición\r\n'),
 (186,'2020-02-09 20:32:54','::1','admin','catalog','add','---Keys\r\nidcatalog : 51\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Autorizado\r\n'),
 (187,'2020-02-09 20:33:17','::1','admin','catalog','add','---Keys\r\nidcatalog : 52\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Subsanar errores\r\n'),
 (188,'2020-02-09 20:33:42','::1','admin','catalog','add','---Keys\r\nidcatalog : 53\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Solicitar aplicar a nómina\r\n'),
 (189,'2020-02-09 20:34:05','::1','admin','catalog','add','---Keys\r\nidcatalog : 54\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: A contabilización\r\n'),
 (190,'2020-02-09 20:34:25','::1','admin','catalog','add','---Keys\r\nidcatalog : 55\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Finalizar\r\n'),
 (191,'2020-02-09 20:35:05','::1','admin','catalog','add','---Keys\r\nidcatalog : 56\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 8\r\ncatalogCode [new]: Terminar\r\n'),
 (192,'2020-02-09 20:37:05','::1','admin','catalog','add','---Keys\r\nidcatalog : 57\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Complete information\r\n'),
 (193,'2020-02-09 20:37:29','::1','admin','catalog','add','---Keys\r\nidcatalog : 58\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Deny request\r\n'),
 (194,'2020-02-09 20:37:52','::1','admin','catalog','add','---Keys\r\nidcatalog : 59\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Authorized\r\n'),
 (195,'2020-02-09 20:38:12','::1','admin','catalog','add','---Keys\r\nidcatalog : 60\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Fix errors\r\n'),
 (196,'2020-02-09 20:39:09','::1','admin','catalog','add','---Keys\r\nidcatalog : 61\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Request payroll application\r\n'),
 (197,'2020-02-09 20:39:32','::1','admin','catalog','add','---Keys\r\nidcatalog : 62\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: To accounting\r\n'),
 (198,'2020-02-09 20:39:51','::1','admin','catalog','add','---Keys\r\nidcatalog : 63\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Conclude\r\n'),
 (199,'2020-02-09 20:40:07','::1','admin','catalog','add','---Keys\r\nidcatalog : 64\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 8\r\ncatalogCode [new]: Finish\r\n'),
 (200,'2020-02-09 20:40:44','::1','admin','catalog','add','---Keys\r\nidcatalog : 65\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 7\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Justificante\r\n'),
 (201,'2020-02-09 20:41:23','::1','admin','catalog','add','---Keys\r\nidcatalog : 66\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 7\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Proof of payment\r\n'),
 (202,'2020-02-09 20:42:01','::1','admin','ct_status','add','---Keys\r\nidct_status : 8\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 1\r\n'),
 (203,'2020-02-09 20:42:09','::1','admin','ct_status','add','---Keys\r\nidct_status : 9\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 2\r\n'),
 (204,'2020-02-09 20:42:16','::1','admin','ct_status','add','---Keys\r\nidct_status : 10\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 3\r\n'),
 (205,'2020-02-09 20:42:24','::1','admin','ct_status','add','---Keys\r\nidct_status : 11\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 4\r\n'),
 (206,'2020-02-09 20:42:29','::1','admin','ct_status','add','---Keys\r\nidct_status : 12\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 5\r\n'),
 (207,'2020-02-09 20:42:35','::1','admin','ct_status','add','---Keys\r\nidct_status : 13\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 6\r\n'),
 (208,'2020-02-09 20:42:43','::1','admin','ct_status','add','---Keys\r\nidct_status : 14\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 7\r\n'),
 (209,'2020-02-09 20:43:14','::1','admin','catalog','edit','---Keys\r\nidcatalog : 40\r\n---Fields\r\ncatalogCode [old]: Arvhivado\r\ncatalogCode [new]: Archivado\r\n'),
 (210,'2020-02-09 20:43:32','::1','admin','ct_status','edit','---Keys\r\nidct_status : 14\r\n---Fields\r\nisTheEnd [old]: 0\r\nisTheEnd [new]: 1\r\n'),
 (211,'2020-02-09 20:44:24','::1','admin','ct_utility','add','---Keys\r\nidct_utility : 4\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 1\r\nimportanceWeight [new]: 1\r\nurlUtility [new]: ftftft\r\n'),
 (212,'2020-02-09 20:44:37','::1','admin','ct_utility','delete','---Keys\r\nidct_utility : 4\r\n---Fields\r\nprocess_idprocess [old]: 2\r\ncatalogNum [old]: 1\r\nimportanceWeight [old]: 1\r\nurlUtility [old]: ftftft\r\n'),
 (213,'2020-02-09 20:45:02','::1','admin','catalog','delete','---Keys\r\nidcatalog : 65\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 7\r\nlanguage [old]: Spanish\r\ncatalogNum [old]: 1\r\ncatalogCode [old]: Justificante\r\n'),
 (214,'2020-02-09 20:45:02','::1','admin','catalog','delete','---Keys\r\nidcatalog : 66\r\n---Fields\r\nsuper_catalog_idsuper_catalog [old]: 7\r\nlanguage [old]: English\r\ncatalogNum [old]: 1\r\ncatalogCode [old]: Proof of payment\r\n'),
 (215,'2020-02-09 20:45:27','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 7\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 1\r\nimportanceWeight [new]: 1\r\nurlProceeding [new]: eedede\r\n'),
 (216,'2020-02-09 20:45:42','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 8\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 2\r\nimportanceWeight [new]: 2\r\nurlProceeding [new]: ddede\r\n'),
 (217,'2020-02-09 20:45:52','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 9\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 3\r\nimportanceWeight [new]: 3\r\nurlProceeding [new]: dedede\r\n'),
 (218,'2020-02-09 20:46:03','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 10\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 4\r\nimportanceWeight [new]: 4\r\nurlProceeding [new]: ffrfrfr\r\n'),
 (219,'2020-02-09 20:46:15','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 11\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 5\r\nimportanceWeight [new]: 5\r\nurlProceeding [new]: dedede\r\n'),
 (220,'2020-02-09 20:46:25','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 12\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 6\r\nimportanceWeight [new]: 6\r\nurlProceeding [new]: frfrfr\r\n'),
 (221,'2020-02-09 20:46:35','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 13\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 7\r\nimportanceWeight [new]: 7\r\nurlProceeding [new]: frfrfr\r\n'),
 (222,'2020-02-09 20:46:46','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 14\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 8\r\nimportanceWeight [new]: 8\r\nurlProceeding [new]: deded\r\n'),
 (223,'2020-02-09 20:48:21','::1','admin','ct_report','add','---Keys\r\nidct_report : 2\r\n---Fields\r\nprocess_idprocess [new]: 2\r\nct_proceeding_idct_proceeding [new]: 12\r\ntitle [new]: Proof of payment\r\nisPHPWord [new]: 1\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo 1_6hw3kvmw.docx\",\"usrName\":\"plantilla ejemplo 1.docx\",\"size\":15152,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo 1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nconditionFile [new]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_8djs0043.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":146,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [new]: 2020-02-09 20:46:53\r\nlastUpdateUser [new]: admin\r\n'),
 (224,'2020-02-09 20:57:53','::1','admin','status_group','add','---Keys\r\nidstatus_group : 8\r\n---Fields\r\nct_status_idct_status [new]: 8\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (225,'2020-02-09 20:58:13','::1','admin','status_group','add','---Keys\r\nidstatus_group : 9\r\n---Fields\r\nct_status_idct_status [new]: 9\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (226,'2020-02-09 20:58:20','::1','admin','status_group','add','---Keys\r\nidstatus_group : 10\r\n---Fields\r\nct_status_idct_status [new]: 10\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (227,'2020-02-09 20:58:26','::1','admin','status_group','add','---Keys\r\nidstatus_group : 11\r\n---Fields\r\nct_status_idct_status [new]: 11\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (228,'2020-02-09 20:58:33','::1','admin','status_group','add','---Keys\r\nidstatus_group : 12\r\n---Fields\r\nct_status_idct_status [new]: 12\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (229,'2020-02-09 20:58:40','::1','admin','status_group','add','---Keys\r\nidstatus_group : 13\r\n---Fields\r\nct_status_idct_status [new]: 13\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (230,'2020-02-09 20:58:52','::1','admin','status_group','add','---Keys\r\nidstatus_group : 14\r\n---Fields\r\nct_status_idct_status [new]: 14\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (231,'2020-02-09 21:20:04','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 7\r\n---Fields\r\nct_status_idct_status [new]: 8\r\nct_proceeding_idct_proceeding [new]: 7\r\n'),
 (232,'2020-02-09 21:20:13','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 8\r\n---Fields\r\nct_status_idct_status [new]: 8\r\nct_proceeding_idct_proceeding [new]: 8\r\n'),
 (233,'2020-02-09 21:20:19','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 9\r\n---Fields\r\nct_status_idct_status [new]: 8\r\nct_proceeding_idct_proceeding [new]: 9\r\n'),
 (234,'2020-02-09 21:20:31','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 10\r\n---Fields\r\nct_status_idct_status [new]: 9\r\nct_proceeding_idct_proceeding [new]: 10\r\n'),
 (235,'2020-02-09 21:21:51','::1','admin','status_proceeding','delete','---Keys\r\nidstatus_proceeding : 7\r\n---Fields\r\nct_status_idct_status [old]: 8\r\nct_proceeding_idct_proceeding [old]: 7\r\n'),
 (236,'2020-02-09 21:21:51','::1','admin','status_proceeding','delete','---Keys\r\nidstatus_proceeding : 8\r\n---Fields\r\nct_status_idct_status [old]: 8\r\nct_proceeding_idct_proceeding [old]: 8\r\n'),
 (237,'2020-02-09 21:21:51','::1','admin','status_proceeding','delete','---Keys\r\nidstatus_proceeding : 9\r\n---Fields\r\nct_status_idct_status [old]: 8\r\nct_proceeding_idct_proceeding [old]: 9\r\n'),
 (238,'2020-02-09 21:21:51','::1','admin','status_proceeding','delete','---Keys\r\nidstatus_proceeding : 10\r\n---Fields\r\nct_status_idct_status [old]: 9\r\nct_proceeding_idct_proceeding [old]: 10\r\n'),
 (239,'2020-02-09 21:23:43','::1','admin','catalog','add','---Keys\r\nidcatalog : 67\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 9\r\ncatalogCode [new]: Solución de problemas\r\n'),
 (240,'2020-02-09 21:24:11','::1','admin','catalog','add','---Keys\r\nidcatalog : 68\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 6\r\nlanguage [new]: English\r\ncatalogNum [new]: 9\r\ncatalogCode [new]: Troubleshooting\r\n'),
 (241,'2020-02-09 21:24:35','::1','admin','ct_proceeding','add','---Keys\r\nidct_proceeding : 15\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 9\r\nimportanceWeight [new]: 9\r\nurlProceeding [new]: frfr\r\n'),
 (242,'2020-02-09 21:25:18','::1','admin','user','logout',''),
 (243,'2020-02-10 12:58:15','::1','admin','user','login',''),
 (244,'2020-02-10 12:58:22','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (245,'2020-02-10 13:05:11','::1','admin','user','login',''),
 (246,'2020-02-10 13:05:27','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (247,'2020-02-10 13:06:59','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (248,'2020-02-10 13:07:39','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (249,'2020-02-10 13:09:01','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 11\r\n---Fields\r\nct_status_idct_status [new]: 8\r\nct_proceeding_idct_proceeding [new]: 15\r\n'),
 (250,'2020-02-10 13:09:12','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 12\r\n---Fields\r\nct_status_idct_status [new]: 9\r\nct_proceeding_idct_proceeding [new]: 7\r\n'),
 (251,'2020-02-10 13:09:22','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 13\r\n---Fields\r\nct_status_idct_status [new]: 9\r\nct_proceeding_idct_proceeding [new]: 8\r\n'),
 (252,'2020-02-10 13:09:30','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 14\r\n---Fields\r\nct_status_idct_status [new]: 9\r\nct_proceeding_idct_proceeding [new]: 9\r\n'),
 (253,'2020-02-10 13:09:42','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 15\r\n---Fields\r\nct_status_idct_status [new]: 10\r\nct_proceeding_idct_proceeding [new]: 10\r\n'),
 (254,'2020-02-10 13:09:54','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 16\r\n---Fields\r\nct_status_idct_status [new]: 10\r\nct_proceeding_idct_proceeding [new]: 11\r\n'),
 (255,'2020-02-10 13:10:17','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 17\r\n---Fields\r\nct_status_idct_status [new]: 11\r\nct_proceeding_idct_proceeding [new]: 12\r\n'),
 (256,'2020-02-10 13:10:28','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 18\r\n---Fields\r\nct_status_idct_status [new]: 12\r\nct_proceeding_idct_proceeding [new]: 13\r\n'),
 (257,'2020-02-10 13:10:37','::1','admin','status_proceeding','add','---Keys\r\nidstatus_proceeding : 19\r\n---Fields\r\nct_status_idct_status [new]: 13\r\nct_proceeding_idct_proceeding [new]: 14\r\n'),
 (258,'2020-02-10 13:15:55','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 9\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 7\r\nct_status_idct_status [new]: 8\r\n'),
 (259,'2020-02-10 13:16:11','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 10\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 8\r\nct_status_idct_status [new]: 13\r\n'),
 (260,'2020-02-10 13:16:53','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 11\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 9\r\nct_status_idct_status [new]: 10\r\n'),
 (261,'2020-02-10 13:17:22','::1','admin','catalog','edit','---Keys\r\nidcatalog : 37\r\n---Fields\r\ncatalogCode [old]: Pte. Revisar por Contabiliad\r\ncatalogCode [new]: Pte. Revisar por Contabilidad\r\n'),
 (262,'2020-02-10 13:18:07','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 12\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 10\r\nct_status_idct_status [new]: 9\r\n'),
 (263,'2020-02-10 13:18:22','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 13\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 11\r\nct_status_idct_status [new]: 11\r\n'),
 (264,'2020-02-10 13:18:33','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 14\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 11\r\nct_status_idct_status [new]: 12\r\n'),
 (265,'2020-02-10 13:19:01','::1','admin','proceeding_status','edit','---Keys\r\nidproceeding_status : 14\r\n---Fields\r\nct_proceeding_idct_proceeding [old]: 11\r\nct_proceeding_idct_proceeding [new]: 12\r\n'),
 (266,'2020-02-10 13:19:13','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 15\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 13\r\nct_status_idct_status [new]: 14\r\n'),
 (267,'2020-02-10 13:19:21','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 16\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 14\r\nct_status_idct_status [new]: 14\r\n'),
 (268,'2020-02-10 13:19:35','::1','admin','proceeding_status','add','---Keys\r\nidproceeding_status : 17\r\n---Fields\r\nct_proceeding_idct_proceeding [new]: 15\r\nct_status_idct_status [new]: 9\r\n'),
 (269,'2020-02-12 13:43:48','::1','admin','user','login',''),
 (270,'2020-02-12 13:55:20','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (271,'2020-02-12 13:58:05','::1','admin','user','logout',''),
 (272,'2020-02-12 13:58:11','::1','admin','user','login',''),
 (273,'2020-02-12 13:58:13','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (274,'2020-02-12 14:01:42','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (275,'2020-02-21 13:22:59','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (276,'2020-02-21 13:35:55','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (277,'2020-02-21 19:11:37','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (278,'2020-02-21 19:12:02','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (279,'2020-02-21 19:16:04','::1','admin','user','logout',''),
 (280,'2020-02-21 19:16:12','::1','admin','user','login',''),
 (281,'2020-02-21 19:16:20','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (282,'2020-02-21 20:13:50','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (283,'2020-02-21 20:14:25','::1','admin','user','logout',''),
 (284,'2020-02-24 21:05:50','::1','admin','user','login',''),
 (285,'2020-02-24 21:05:53','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (286,'2020-02-24 21:06:47','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (287,'2020-02-24 21:07:11','::1','admin','user','logout',''),
 (288,'2020-02-29 12:58:09','::1','admin','user','login',''),
 (289,'2020-02-29 12:58:13','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (290,'2020-02-29 13:10:02','::1','admin','user','login',''),
 (291,'2020-02-29 13:10:04','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (292,'2020-03-20 20:10:53','::1','admin','user','login',''),
 (293,'2020-03-20 20:10:58','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (294,'2020-03-20 20:24:42','::1','admin','user','login',''),
 (295,'2020-03-20 20:24:44','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (296,'2020-03-20 20:45:22','::1','admin','user','logout',''),
 (297,'2020-03-20 20:45:31','::1','admin','user','login',''),
 (298,'2020-03-20 20:45:34','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (299,'2020-03-20 20:56:53','::1','admin','user','logout',''),
 (300,'2020-03-23 17:46:53','::1','admin','user','login',''),
 (301,'2020-03-23 17:46:56','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (302,'2020-03-23 18:08:09','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (303,'2020-03-23 18:24:38','::1','admin','user','logout',''),
 (304,'2020-03-23 18:24:44','::1','admin','user','login',''),
 (305,'2020-03-23 18:26:24','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (306,'2020-03-23 18:35:44','::1','admin','expedient','add','---Keys\r\nidexpedient : 1\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_status_idct_status [new]: 1\r\ncodeExpedient [new]: EX04/000004/2020\r\ntitle [new]: Prueba 4\r\nobservations [new]: Observacion\r\ncreationDate [new]: 2020-03-23 18:35:12\r\ncreationUser [new]: 1\r\nlastUpdateDate [new]: 2020-03-23 18:35:12\r\nlastUpdateUser [new]: 1\r\n'),
 (307,'2020-03-23 19:50:03','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 8\r\n---Fields\r\nsuperCode [new]: ALERT_CLASS\r\ndescription [new]: Alert Classes\r\n'),
 (308,'2020-03-23 19:51:14','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 9\r\n---Fields\r\nsuperCode [new]: ALERT_SITUATION\r\ndescription [new]: Alerts status\r\n'),
 (309,'2020-03-23 19:52:36','::1','admin','catalog','add','---Keys\r\nidcatalog : 69\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Espera de Documentación\r\n'),
 (310,'2020-03-23 19:53:12','::1','admin','catalog','add','---Keys\r\nidcatalog : 70\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Plazo de reclamación de resolución\r\n'),
 (311,'2020-03-23 19:53:28','::1','admin','catalog','add','---Keys\r\nidcatalog : 71\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Otros plazos legales\r\n'),
 (312,'2020-03-23 19:53:53','::1','admin','catalog','add','---Keys\r\nidcatalog : 72\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Especial tratamiento\r\n'),
 (313,'2020-03-23 19:54:36','::1','admin','catalog','add','---Keys\r\nidcatalog : 73\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: English\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Waiting for Documentation\r\n'),
 (314,'2020-03-23 19:55:05','::1','admin','catalog','add','---Keys\r\nidcatalog : 74\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Term of claim for resolution\r\n'),
 (315,'2020-03-23 19:55:31','::1','admin','catalog','add','---Keys\r\nidcatalog : 75\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Other legal terms\r\n'),
 (316,'2020-03-23 19:56:02','::1','admin','catalog','add','---Keys\r\nidcatalog : 76\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 8\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Special treatment\r\n'),
 (317,'2020-03-23 19:57:12','::1','admin','catalog','add','---Keys\r\nidcatalog : 77\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Activa\r\n'),
 (318,'2020-03-23 19:57:26','::1','admin','catalog','add','---Keys\r\nidcatalog : 78\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Pausada\r\n'),
 (319,'2020-03-23 19:57:55','::1','admin','catalog','add','---Keys\r\nidcatalog : 79\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Vencida o Archivada\r\n'),
 (320,'2020-03-23 20:22:44','::1','admin','catalog','add','---Keys\r\nidcatalog : 80\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: English\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Active\r\n'),
 (321,'2020-03-23 20:23:08','::1','admin','catalog','add','---Keys\r\nidcatalog : 81\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Pause\r\n'),
 (322,'2020-03-23 20:23:27','::1','admin','catalog','add','---Keys\r\nidcatalog : 82\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 9\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Expired or Archived\r\n'),
 (323,'2020-03-23 20:56:46','::1','admin','alerts','add','---Keys\r\nidalerts : 1\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\ncreationDate [new]: 2020-03-23 20:56:07\r\nalertDate [new]: 2020-04-02 08:00:00\r\nalertClass [new]: 0\r\nsituation [new]: 0\r\ncreationUser [new]: admin\r\nlastUpdateDate [new]: 2020-03-23 20:56:07\r\nlastUpdateUser [new]: admin\r\n'),
 (324,'2020-03-23 21:01:05','::1','admin','user','logout',''),
 (325,'2020-03-24 13:05:04','::1','admin','user','login',''),
 (326,'2020-03-24 13:05:07','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (327,'2020-03-24 13:28:38','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 10\r\n---Fields\r\nsuperCode [new]: DOCUMENT_EE\r\ndescription [new]: Document Entry or Exit\r\n'),
 (328,'2020-03-24 13:28:59','::1','admin','catalog','add','---Keys\r\nidcatalog : 83\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 10\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Entrada\r\n'),
 (329,'2020-03-24 13:29:13','::1','admin','catalog','add','---Keys\r\nidcatalog : 84\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 10\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Salida\r\n'),
 (330,'2020-03-24 13:29:35','::1','admin','catalog','add','---Keys\r\nidcatalog : 85\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 10\r\nlanguage [new]: English\r\ncatalogNum [new]: 0\r\ncatalogCode [new]: Entry\r\n'),
 (331,'2020-03-24 13:29:47','::1','admin','catalog','add','---Keys\r\nidcatalog : 86\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 10\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Exit\r\n'),
 (332,'2020-03-24 13:47:11','::1','admin','document','add','---Keys\r\niddocument : 1\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\nDocumentNum [new]: 1234567890123456\r\nTitle [new]: Documento 1\r\nentryOrExit [new]: 0\r\ncreationDate [new]: 2020-03-24 13:46:18\r\nlastUpdateDate [new]: 2020-03-24 13:46:18\r\nlastUpdateUser [new]: admin\r\n'),
 (333,'2020-03-24 13:54:48','::1','admin','document','add','---Keys\r\niddocument : 2\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\nDocumentNum [new]: DOC/000002/2020\r\nTitle [new]: Documento 2\r\nentryOrExit [new]: 0\r\ncreationDate [new]: 2020-03-24 13:54:39\r\nlastUpdateDate [new]: 2020-03-24 13:54:39\r\nlastUpdateUser [new]: admin\r\n'),
 (334,'2020-03-24 14:16:12','::1','admin','config','add','---Keys\r\nidconfig : 4\r\n---Fields\r\nname [new]: FILES_DOCUMENT\r\nvalue [new]: ../Documentos/Workflow2/\r\n'),
 (335,'2020-03-24 14:20:25','::1','admin','user','logout',''),
 (336,'2020-03-24 14:20:36','::1','admin','user','login',''),
 (337,'2020-03-24 14:20:39','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (338,'2020-03-24 14:22:03','::1','admin','file','add','---Keys\r\nidfile : 1\r\n---Fields\r\ndocument_iddocument [new]: 1\r\ntitle [new]: fichero 1\r\nfileContent [new]: [{\"name\":\"..\\/Documentos\\/Workflow2\\/\\/model_9a7uqhna.pdf\",\"usrName\":\"model.pdf\",\"size\":62107,\"type\":\"application\\/pdf\",\"searchStr\":\"model.pdf,!:sStrEnd\"}]\r\ncreationDate [new]: 2020-03-24 14:20:57\r\nlastUpdateDate [new]: 2020-03-24 14:20:57\r\nlastUpdateUser [new]: admin\r\n'),
 (339,'2020-03-24 14:23:07','::1','admin','file','delete','---Keys\r\nidfile : 1\r\n---Fields\r\ndocument_iddocument [old]: 1\r\ntitle [old]: fichero 1\r\nfileContent [old]: [{\"name\":\"..\\/Documentos\\/Workflow2\\/\\/model_9a7uqhna.pdf\",\"usrName\":\"model.pdf\",\"size\":62107,\"type\":\"application\\/pdf\",\"searchStr\":\"model.pdf,!:sStrEnd\"}]\r\ncreationDate [old]: 2020-03-24 14:20:57\r\nlastUpdateDate [old]: 2020-03-24 14:20:57\r\nlastUpdateUser [old]: admin\r\n'),
 (340,'2020-03-24 19:49:20','::1','admin','process_logbook','add','---Keys\r\nidprocess_logbook : 1\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\nct_proceeding_idct_proceeding [new]: 1\r\nbeforeStatus [new]: 1\r\nafterStatus [new]: 2\r\nobservations [new]: dededeed\r\nlastUpdateDate [new]: 2020-03-24 19:49:05\r\nlastUpdateUser [new]: admin\r\n'),
 (341,'2020-03-25 18:02:25','::1','admin','user','login',''),
 (342,'2020-03-25 18:02:29','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (343,'2020-03-25 19:03:56','::1','admin','alerts','add','---Keys\r\nidalerts : 2\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\ncreationDate [new]: 2020-03-25 19:03:30\r\nalertDate [new]: 2020-03-25 00:00:00\r\nalertClass [new]: 0\r\nsituation [new]: 0\r\ncreationUser [new]: admin\r\nlastUpdateDate [new]: 2020-03-25 19:03:30\r\nlastUpdateUser [new]: admin\r\n'),
 (344,'2020-03-25 19:04:12','::1','admin','alerts','add','---Keys\r\nidalerts : 3\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\ncreationDate [new]: 2020-03-25 19:04:03\r\nalertDate [new]: 2020-03-24 00:00:00\r\nalertClass [new]: 0\r\nsituation [new]: 1\r\ncreationUser [new]: admin\r\nlastUpdateDate [new]: 2020-03-25 19:04:03\r\nlastUpdateUser [new]: admin\r\n'),
 (345,'2020-03-25 19:04:40','::1','admin','alerts','add','---Keys\r\nidalerts : 4\r\n---Fields\r\nexpedient_idexpedient [new]: 1\r\ncreationDate [new]: 2020-03-25 19:04:19\r\nalertDate [new]: 2020-03-26 00:00:00\r\nalertClass [new]: 0\r\nsituation [new]: 2\r\ncreationUser [new]: admin\r\nlastUpdateDate [new]: 2020-03-25 19:04:19\r\nlastUpdateUser [new]: admin\r\n'),
 (346,'2020-03-25 20:29:51','::1','admin','user','add','---Keys\r\niduser : 2\r\n---Fields\r\nlogin [new]: user1\r\npassword [new]: user1\r\nNameAndSurname [new]: User1\r\nemail [new]: info@fhumanes.com\r\nchief_iduser [new]: 1\r\nactive [new]: 1\r\nlastProcessWorked [new]: 1\r\n'),
 (347,'2020-03-25 20:30:24','::1','admin','user','add','---Keys\r\niduser : 3\r\n---Fields\r\nlogin [new]: user2\r\npassword [new]: user2\r\nNameAndSurname [new]: User2\r\nemail [new]: info@fhumanes.com\r\nchief_iduser [new]: 1\r\nactive [new]: 1\r\nlastProcessWorked [new]: 1\r\n'),
 (348,'2020-03-25 20:31:06','::1','admin','user_group','add','---Keys\r\niduser_group : 4\r\n---Fields\r\nuser_iduser [new]: 2\r\naccess_group_idaccess_group [new]: 1\r\n');
INSERT INTO `wf2_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (349,'2020-03-25 20:31:17','::1','admin','user_group','add','---Keys\r\niduser_group : 5\r\n---Fields\r\nuser_iduser [new]: 3\r\naccess_group_idaccess_group [new]: 1\r\n'),
 (350,'2020-03-25 20:32:42','::1','admin','status_group','add','---Keys\r\nidstatus_group : 15\r\n---Fields\r\nct_status_idct_status [new]: 1\r\naccess_group_idaccess_group [new]: 1\r\n'),
 (351,'2020-03-26 19:30:25','::1','admin','expedient','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nlastUpdateDate [old]: 2020-03-23 18:35:12\r\nlastUpdateDate [new]: 2020-03-26 19:30:17\r\nassignedUser [old]: \r\nassignedUser [new]: 2\r\n'),
 (352,'2020-03-26 19:32:06','::1','admin','expedient','add','---Keys\r\nidexpedient : 2\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_status_idct_status [new]: 2\r\ncodeExpedient [new]: EX04/000008/2020\r\ntitle [new]: Prueba 2\r\nassignedUser [new]: 1\r\ncreationDate [new]: 2020-03-26 19:31:47\r\ncreationUser [new]: 1\r\nlastUpdateDate [new]: 2020-03-26 19:31:47\r\nlastUpdateUser [new]: 1\r\n'),
 (353,'2020-03-26 19:32:38','::1','admin','expedient','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nlastUpdateDate [old]: 2020-03-26 19:30:17\r\nlastUpdateDate [new]: 2020-03-26 19:32:23\r\nassignedUser [old]: 2\r\nassignedUser [new]: \r\n'),
 (354,'2020-03-26 19:36:56','::1','admin','expedient','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nlastUpdateDate [old]: 2020-03-26 19:32:23\r\nlastUpdateDate [new]: 2020-03-26 19:36:52\r\nassignedUser [old]: \r\nassignedUser [new]: 2\r\n'),
 (355,'2020-03-26 21:07:34','::1','admin','user','logout',''),
 (356,'2020-03-26 21:07:43','::1','admin','user','login',''),
 (357,'2020-03-26 21:07:47','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (358,'2020-03-27 20:58:13','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (359,'2020-03-30 13:54:26','::1','admin','user','login',''),
 (360,'2020-03-30 13:54:33','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (361,'2020-03-30 14:16:20','::1','admin','user','login',''),
 (362,'2020-03-30 14:16:22','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (363,'2020-03-30 18:10:50','::1','admin','user','logout',''),
 (364,'2020-03-30 18:10:59','::1','user1','user','failed login',''),
 (365,'2020-03-30 18:11:04','::1','user1','user','failed login',''),
 (366,'2020-03-30 18:11:20','::1','user1','user','failed login',''),
 (367,'2020-03-30 18:11:28','::1','admin','user','login',''),
 (368,'2020-03-30 18:19:07','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (369,'2020-03-30 18:26:15','::1','admin','user','edit','---Keys\r\niduser : 2\r\n'),
 (370,'2020-03-30 18:26:24','::1','admin','user','edit','---Keys\r\niduser : 2\r\n---Fields\r\npassword [old]: user1\r\npassword [new]: c0473da44e43b90549ff8da99d0da4b7\r\n'),
 (371,'2020-03-30 18:26:35','::1','admin','user','edit','---Keys\r\niduser : 2\r\n---Fields\r\npassword [old]: c0473da44e43b90549ff8da99d0da4b7\r\npassword [new]: 24c9e15e52afc47c225b757e7bee1f9d\r\n'),
 (372,'2020-03-30 18:26:42','::1','admin','user','edit','---Keys\r\niduser : 3\r\n---Fields\r\npassword [old]: user2\r\npassword [new]: f9ad80b87edfe93f485125fcb95fb0a3\r\n'),
 (373,'2020-03-30 18:26:52','::1','admin','user','edit','---Keys\r\niduser : 2\r\n'),
 (374,'2020-03-30 18:26:59','::1','admin','user','edit','---Keys\r\niduser : 3\r\n---Fields\r\npassword [old]: f9ad80b87edfe93f485125fcb95fb0a3\r\npassword [new]: 7e58d63b60197ceb55a1c487989a3720\r\n'),
 (375,'2020-03-30 18:27:04','::1','admin','user','logout',''),
 (376,'2020-03-30 18:27:10','::1','user1','user','login',''),
 (377,'2020-03-30 18:27:13','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n'),
 (378,'2020-03-30 18:28:18','::1','user1','user','logout',''),
 (379,'2020-03-30 18:28:26','::1','admin','user','login',''),
 (380,'2020-03-30 18:28:28','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (381,'2020-03-30 19:28:49','::1','admin','process','edit','---Keys\r\nidprocess : 1\r\n'),
 (382,'2020-03-30 19:47:36','::1','admin','user','logout',''),
 (383,'2020-03-30 19:48:22','::1','admin','user','login',''),
 (384,'2020-03-30 19:48:24','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (385,'2020-03-30 20:58:26','::1','admin','user','logout',''),
 (386,'2020-03-30 20:58:36','::1','user1','user','login',''),
 (387,'2020-03-30 20:58:38','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n'),
 (388,'2020-03-30 21:05:50','::1','user1','user','logout',''),
 (389,'2020-03-31 17:19:35','::1','admin','user','login',''),
 (390,'2020-03-31 17:19:38','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (391,'2020-03-31 17:20:25','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 1\r\n---Fields\r\nurlProceeding [old]: vv\r\nurlProceeding [new]: EX04_proceeding_edit.php\r\n'),
 (392,'2020-03-31 17:20:35','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 2\r\n---Fields\r\nurlProceeding [old]: www\r\nurlProceeding [new]: EX04_proceeding_edit.php\r\n'),
 (393,'2020-03-31 17:20:44','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 3\r\n---Fields\r\nurlProceeding [old]: www\r\nurlProceeding [new]: EX04_proceeding_edit.php\r\n'),
 (394,'2020-03-31 17:20:51','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 4\r\n---Fields\r\nurlProceeding [old]: ww\r\nurlProceeding [new]: EX04_proceeding_edit.php\r\n'),
 (395,'2020-03-31 17:20:57','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 5\r\n---Fields\r\nurlProceeding [old]: ww\r\nurlProceeding [new]: EX04_proceeding_edit.php\r\n'),
 (396,'2020-03-31 17:21:03','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 6\r\n---Fields\r\nurlProceeding [old]: ww\r\nurlProceeding [new]: EX04_proceeding_edit.php\r\n'),
 (397,'2020-03-31 17:21:38','::1','admin','ct_utility','edit','---Keys\r\nidct_utility : 1\r\n---Fields\r\nurlUtility [old]: update\r\nurlUtility [new]: EX04_utility_edit.php\r\n'),
 (398,'2020-03-31 21:00:23','::1','admin','process','edit','---Keys\r\nidprocess : 1\r\n---Fields\r\nurlAdd [old]: EX04_expedient_add.php\r\nurlAdd [new]: ex04_expedient_add.php\r\nurlEdit [old]: EX04_expedient_edit.php\r\nurlEdit [new]: ex04_expedient_edit.php\r\nurlView [old]: EX04_expedient_view.php\r\nurlView [new]: ex04_expedient_view.php\r\n'),
 (399,'2020-03-31 21:00:37','::1','admin','process','edit','---Keys\r\nidprocess : 1\r\n'),
 (400,'2020-03-31 21:00:54','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 1\r\n---Fields\r\nurlProceeding [old]: EX04_proceeding_edit.php\r\nurlProceeding [new]: ex04_proceeding_edit.php\r\n'),
 (401,'2020-03-31 21:01:05','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 2\r\n---Fields\r\nurlProceeding [old]: EX04_proceeding_edit.php\r\nurlProceeding [new]: ex04_proceeding_edit.php\r\n'),
 (402,'2020-03-31 21:01:13','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 3\r\n---Fields\r\nurlProceeding [old]: EX04_proceeding_edit.php\r\nurlProceeding [new]: ex04_proceeding_edit.php\r\n'),
 (403,'2020-03-31 21:01:29','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 4\r\n---Fields\r\nurlProceeding [old]: EX04_proceeding_edit.php\r\nurlProceeding [new]: ex04_proceeding_edit.php\r\n'),
 (404,'2020-03-31 21:01:38','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 5\r\n---Fields\r\nurlProceeding [old]: EX04_proceeding_edit.php\r\nurlProceeding [new]: ex04_proceeding_edit.php\r\n'),
 (405,'2020-03-31 21:01:49','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 6\r\n---Fields\r\nurlProceeding [old]: EX04_proceeding_edit.php\r\nurlProceeding [new]: ex04_proceeding_edit.php\r\n'),
 (406,'2020-03-31 21:02:05','::1','admin','ct_utility','edit','---Keys\r\nidct_utility : 1\r\n---Fields\r\nurlUtility [old]: EX04_utility_edit.php\r\nurlUtility [new]: ex04_utility_edit.php\r\n'),
 (407,'2020-03-31 21:02:59','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-03-26 19:31:47\r\nlastUpdateDate [new]: 2020-03-31 21:02:56\r\n'),
 (408,'2020-03-31 21:03:17','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-03-31 21:02:56\r\nlastUpdateDate [new]: 2020-03-31 21:03:10\r\n'),
 (409,'2020-04-01 12:05:12','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-03-31 21:03:10\r\nlastUpdateDate [new]: 2020-04-01 12:05:06\r\n'),
 (410,'2020-04-01 13:59:26','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-01 12:05:06\r\nlastUpdateDate [new]: 2020-04-01 13:59:23\r\n'),
 (411,'2020-04-01 17:35:16','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 13:59:23\r\nlastUpdateDate [new]: 2020-04-01 17:34:38\r\n'),
 (412,'2020-04-01 17:37:19','::1','admin','user','logout',''),
 (413,'2020-04-01 17:37:27','::1','user1','user','login',''),
 (414,'2020-04-01 17:37:30','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n'),
 (415,'2020-04-01 17:38:14','::1','user1','user','logout',''),
 (416,'2020-04-01 17:38:21','::1','admin','user','login',''),
 (417,'2020-04-01 17:38:31','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (418,'2020-04-01 17:38:58','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 17:34:38\r\nlastUpdateDate [new]: 2020-04-01 17:38:40\r\n'),
 (419,'2020-04-01 18:00:41','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 17:38:40\r\nlastUpdateDate [new]: 2020-04-01 18:00:26\r\n'),
 (420,'2020-04-01 18:01:14','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 18:00:26\r\nlastUpdateDate [new]: 2020-04-01 18:01:03\r\n'),
 (421,'2020-04-01 18:09:15','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\nconditionFile [old]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_zbo96wyg.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":146,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nconditionFile [new]: \r\nlastUpdateDate [old]: 2020-02-03 13:03:59\r\nlastUpdateDate [new]: 2020-04-01 18:09:15\r\n'),
 (422,'2020-04-01 18:09:30','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\nconditionFile [old]: \r\nconditionFile [new]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_ahqu17vi.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":171,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-01 18:09:15\r\nlastUpdateDate [new]: 2020-04-01 18:09:30\r\n'),
 (423,'2020-04-01 19:11:07','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-01 18:01:03\r\nlastUpdateDate [new]: 2020-04-01 19:10:57\r\n'),
 (424,'2020-04-01 19:16:51','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-01 19:10:57\r\nlastUpdateDate [new]: 2020-04-01 19:16:41\r\n'),
 (425,'2020-04-01 19:17:03','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:16:41\r\nlastUpdateDate [new]: 2020-04-01 19:16:58\r\n'),
 (426,'2020-04-01 19:17:12','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 19:16:58\r\nlastUpdateDate [new]: 2020-04-01 19:17:06\r\n'),
 (427,'2020-04-01 19:19:05','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-01 19:17:06\r\nlastUpdateDate [new]: 2020-04-01 19:18:57\r\n'),
 (428,'2020-04-01 19:19:19','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:18:57\r\nlastUpdateDate [new]: 2020-04-01 19:19:14\r\n'),
 (429,'2020-04-01 19:19:29','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 19:19:14\r\nlastUpdateDate [new]: 2020-04-01 19:19:22\r\n'),
 (430,'2020-04-01 19:26:02','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo 1_8mrv36lf.docx\",\"usrName\":\"plantilla ejemplo 1.docx\",\"size\":15152,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo 1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/CondicionInformeEjemplo_lrkr2xu0.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":170,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-01 18:09:30\r\nlastUpdateDate [new]: 2020-04-01 19:26:02\r\n'),
 (431,'2020-04-01 19:26:36','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/CondicionInformeEjemplo_lrkr2xu0.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":170,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_i8no4kg0.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":1427,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_cb350ox0.docx\",\"usrName\":\"plantilla ejemplo_\r\nlastUpdateDate [old]: 2020-04-01 19:26:02\r\nlastUpdateDate [new]: 2020-04-01 19:26:36\r\n'),
 (432,'2020-04-01 19:26:48','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:19:22\r\nlastUpdateDate [new]: 2020-04-01 19:26:43\r\n'),
 (433,'2020-04-01 19:28:09','::1','admin','document','delete','---Keys\r\niddocument : 3\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000005/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 19:19:29\r\nlastUpdateDate [old]: 2020-04-01 19:19:29\r\nlastUpdateUser [old]: admin\r\n'),
 (434,'2020-04-01 19:28:19','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 19:26:43\r\nlastUpdateDate [new]: 2020-04-01 19:28:04\r\n'),
 (435,'2020-04-01 19:36:25','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:28:04\r\nlastUpdateDate [new]: 2020-04-01 19:36:21\r\n'),
 (436,'2020-04-01 19:36:38','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 19:36:21\r\nlastUpdateDate [new]: 2020-04-01 19:36:30\r\n'),
 (437,'2020-04-01 19:37:22','::1','admin','document','delete','---Keys\r\niddocument : 4\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000006/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 19:28:19\r\nlastUpdateDate [old]: 2020-04-01 19:28:19\r\nlastUpdateUser [old]: admin\r\n'),
 (438,'2020-04-01 19:37:22','::1','admin','document','delete','---Keys\r\niddocument : 5\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000007/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 19:36:38\r\nlastUpdateDate [old]: 2020-04-01 19:36:38\r\nlastUpdateUser [old]: admin\r\n'),
 (439,'2020-04-01 19:40:38','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:36:30\r\nlastUpdateDate [new]: 2020-04-01 19:40:33\r\n'),
 (440,'2020-04-01 19:40:48','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 19:40:33\r\nlastUpdateDate [new]: 2020-04-01 19:40:40\r\n'),
 (441,'2020-04-01 19:45:30','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:40:40\r\nlastUpdateDate [new]: 2020-04-01 19:45:24\r\n'),
 (442,'2020-04-01 19:45:44','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 19:45:24\r\nlastUpdateDate [new]: 2020-04-01 19:45:33\r\n'),
 (443,'2020-04-01 19:47:00','::1','admin','user','logout',''),
 (444,'2020-04-01 20:12:55','::1','admin','user','login',''),
 (445,'2020-04-01 20:13:05','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (446,'2020-04-01 20:13:21','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 19:45:33\r\nlastUpdateDate [new]: 2020-04-01 20:13:16\r\n'),
 (447,'2020-04-01 20:13:55','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:13:16\r\nlastUpdateDate [new]: 2020-04-01 20:13:26\r\n'),
 (448,'2020-04-01 20:17:09','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 20:13:26\r\nlastUpdateDate [new]: 2020-04-01 20:17:03\r\n'),
 (449,'2020-04-01 20:17:29','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:17:03\r\nlastUpdateDate [new]: 2020-04-01 20:17:21\r\n'),
 (450,'2020-04-01 20:18:39','::1','admin','document','delete','---Keys\r\niddocument : 6\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000008/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 19:40:48\r\nlastUpdateDate [old]: 2020-04-01 19:40:48\r\nlastUpdateUser [old]: admin\r\n'),
 (451,'2020-04-01 20:18:39','::1','admin','document','delete','---Keys\r\niddocument : 7\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000009/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 19:45:44\r\nlastUpdateDate [old]: 2020-04-01 19:45:44\r\nlastUpdateUser [old]: admin\r\n'),
 (452,'2020-04-01 20:18:39','::1','admin','document','delete','---Keys\r\niddocument : 8\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000010/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:14:33\r\nlastUpdateDate [old]: 2020-04-01 20:14:33\r\nlastUpdateUser [old]: admin\r\n'),
 (453,'2020-04-01 20:18:39','::1','admin','document','delete','---Keys\r\niddocument : 9\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000011/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:17:40\r\nlastUpdateDate [old]: 2020-04-01 20:17:40\r\nlastUpdateUser [old]: admin\r\n'),
 (454,'2020-04-01 20:21:55','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 20:17:21\r\nlastUpdateDate [new]: 2020-04-01 20:21:51\r\n'),
 (455,'2020-04-01 20:22:22','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:21:51\r\nlastUpdateDate [new]: 2020-04-01 20:22:02\r\n'),
 (456,'2020-04-01 20:35:17','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 20:22:02\r\nlastUpdateDate [new]: 2020-04-01 20:35:11\r\n'),
 (457,'2020-04-01 20:35:33','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 2\r\nlastUpdateDate [old]: 2020-04-01 20:35:11\r\nlastUpdateDate [new]: 2020-04-01 20:35:26\r\n'),
 (458,'2020-04-01 20:38:51','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 2\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 20:35:26\r\nlastUpdateDate [new]: 2020-04-01 20:38:43\r\n'),
 (459,'2020-04-01 20:39:02','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:38:43\r\nlastUpdateDate [new]: 2020-04-01 20:38:54\r\n'),
 (460,'2020-04-01 20:41:41','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ntitle [old]: Primer documento Word\r\ntitle [new]: Petición\r\nlastUpdateDate [old]: 2020-04-01 19:26:36\r\nlastUpdateDate [new]: 2020-04-01 20:41:41\r\n'),
 (461,'2020-04-01 20:41:58','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ntitle [old]: Petición\r\ntitle [new]: Peticion\r\nlastUpdateDate [old]: 2020-04-01 20:41:41\r\nlastUpdateDate [new]: 2020-04-01 20:41:58\r\n'),
 (462,'2020-04-01 20:42:45','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-01 20:38:54\r\nlastUpdateDate [new]: 2020-04-01 20:42:36\r\n'),
 (463,'2020-04-01 20:49:51','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 20:42:36\r\nlastUpdateDate [new]: 2020-04-01 20:49:46\r\n'),
 (464,'2020-04-01 20:50:05','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:49:46\r\nlastUpdateDate [new]: 2020-04-01 20:49:56\r\n'),
 (465,'2020-04-01 20:51:24','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-01 20:49:56\r\nlastUpdateDate [new]: 2020-04-01 20:50:58\r\n'),
 (466,'2020-04-01 20:52:32','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 5\r\nlastUpdateDate [old]: 2020-04-01 20:50:58\r\nlastUpdateDate [new]: 2020-04-01 20:52:20\r\n'),
 (467,'2020-04-01 20:53:37','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 5\r\nct_status_idct_status [new]: 6\r\nlastUpdateDate [old]: 2020-04-01 20:52:20\r\nlastUpdateDate [new]: 2020-04-01 20:53:29\r\n'),
 (468,'2020-04-01 20:53:59','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 6\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:53:29\r\nlastUpdateDate [new]: 2020-04-01 20:53:52\r\n'),
 (469,'2020-04-01 20:54:11','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-01 20:53:52\r\nlastUpdateDate [new]: 2020-04-01 20:54:04\r\n'),
 (470,'2020-04-01 20:57:48','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 20:54:04\r\nlastUpdateDate [new]: 2020-04-01 20:57:42\r\n'),
 (471,'2020-04-01 20:57:58','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 20:57:42\r\nlastUpdateDate [new]: 2020-04-01 20:57:51\r\n'),
 (472,'2020-04-01 20:58:47','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-01 20:57:51\r\nlastUpdateDate [new]: 2020-04-01 20:58:40\r\n'),
 (473,'2020-04-01 21:00:44','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 5\r\nlastUpdateDate [old]: 2020-04-01 20:58:40\r\nlastUpdateDate [new]: 2020-04-01 21:00:36\r\n'),
 (474,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 10\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000012/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:22:32\r\nlastUpdateDate [old]: 2020-04-01 20:22:32\r\nlastUpdateUser [old]: admin\r\n'),
 (475,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 11\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000013/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:35:43\r\nlastUpdateDate [old]: 2020-04-01 20:35:43\r\nlastUpdateUser [old]: admin\r\n'),
 (476,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 12\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000014/2020\r\nTitle [old]: Primer documento Word\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:39:02\r\nlastUpdateDate [old]: 2020-04-01 20:39:02\r\nlastUpdateUser [old]: admin\r\n'),
 (477,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 13\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000015/2020\r\nTitle [old]: Proof of payment\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:42:45\r\nlastUpdateDate [old]: 2020-04-01 20:42:45\r\nlastUpdateUser [old]: admin\r\n'),
 (478,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 14\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000016/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:50:05\r\nlastUpdateDate [old]: 2020-04-01 20:50:05\r\nlastUpdateUser [old]: admin\r\n'),
 (479,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 15\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000017/2020\r\nTitle [old]: Proof of payment\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:52:11\r\nlastUpdateDate [old]: 2020-04-01 20:52:11\r\nlastUpdateUser [old]: admin\r\n'),
 (480,'2020-04-01 21:01:19','::1','admin','document','delete','---Keys\r\niddocument : 16\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000018/2020\r\nTitle [old]: Proof of payment\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 20:54:42\r\nlastUpdateDate [old]: 2020-04-01 20:54:42\r\nlastUpdateUser [old]: admin\r\n'),
 (481,'2020-04-01 21:05:31','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 5\r\nct_status_idct_status [new]: 6\r\nlastUpdateDate [old]: 2020-04-01 21:00:36\r\nlastUpdateDate [new]: 2020-04-01 21:05:23\r\n'),
 (482,'2020-04-01 21:07:05','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 6\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-01 21:05:23\r\nlastUpdateDate [new]: 2020-04-01 21:06:59\r\n'),
 (483,'2020-04-01 21:07:18','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-01 21:06:59\r\nlastUpdateDate [new]: 2020-04-01 21:07:12\r\n'),
 (484,'2020-04-01 21:07:29','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-01 21:07:12\r\nlastUpdateDate [new]: 2020-04-01 21:07:23\r\n'),
 (485,'2020-04-01 21:07:40','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-01 21:07:23\r\nlastUpdateDate [new]: 2020-04-01 21:07:34\r\n'),
 (486,'2020-04-01 21:08:52','::1','admin','user','logout',''),
 (487,'2020-04-02 12:33:18','::1','admin','user','login',''),
 (488,'2020-04-02 12:33:35','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (489,'2020-04-02 12:33:53','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (490,'2020-04-02 12:34:37','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\ntitle [old]: Prueba 4\r\ntitle [new]: Test 4\r\nassignedUser [old]: 2\r\nassignedUser [new]: \r\nlastUpdateDate [old]: 2020-03-26 19:36:52\r\nlastUpdateDate [new]: 2020-04-02 12:34:23\r\n'),
 (491,'2020-04-02 12:35:01','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\ntitle [old]: Prueba 2\r\ntitle [new]: Test 2\r\nassignedUser [old]: 1\r\nassignedUser [new]: \r\nlastUpdateDate [old]: 2020-04-01 21:07:34\r\nlastUpdateDate [new]: 2020-04-02 12:34:49\r\n'),
 (492,'2020-04-02 12:59:42','::1','admin','user','logout',''),
 (493,'2020-04-02 12:59:48','::1','admin','user','login',''),
 (494,'2020-04-02 13:09:01','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (495,'2020-04-02 13:09:06','::1','admin','user','logout',''),
 (496,'2020-04-02 13:09:14','::1','admin','user','login',''),
 (497,'2020-04-02 13:09:19','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (498,'2020-04-02 13:49:03','::1','admin','document','delete','---Keys\r\niddocument : 2\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000002/2020\r\nTitle [old]: Documento 2\r\nentryOrExit [old]: 0\r\ncreationDate [old]: 2020-03-24 13:54:39\r\nlastUpdateDate [old]: 2020-03-24 13:54:39\r\nlastUpdateUser [old]: admin\r\n'),
 (499,'2020-04-02 13:49:03','::1','admin','document','delete','---Keys\r\niddocument : 1\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: 1234567890123456\r\nTitle [old]: Documento 1\r\nentryOrExit [old]: 0\r\ncreationDate [old]: 2020-03-24 13:46:18\r\nlastUpdateDate [old]: 2020-03-24 13:46:18\r\nlastUpdateUser [old]: admin\r\n'),
 (500,'2020-04-02 14:12:04','::1','admin','user','login',''),
 (501,'2020-04-02 14:12:06','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (502,'2020-04-02 14:12:21','::1','admin','document','delete','---Keys\r\niddocument : 18\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000020/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 21:07:40\r\nlastUpdateDate [old]: 2020-04-01 21:07:40\r\nlastUpdateUser [old]: admin\r\n'),
 (503,'2020-04-02 14:12:21','::1','admin','document','delete','---Keys\r\niddocument : 17\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000019/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-01 21:00:06\r\nlastUpdateDate [old]: 2020-04-01 21:00:06\r\nlastUpdateUser [old]: admin\r\n'),
 (504,'2020-04-02 14:12:32','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-02 12:34:49\r\nlastUpdateDate [new]: 2020-04-02 14:12:26\r\n'),
 (505,'2020-04-02 14:12:40','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-02 14:12:26\r\nlastUpdateDate [new]: 2020-04-02 14:12:35\r\n'),
 (506,'2020-04-02 14:12:51','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-02 14:12:35\r\nlastUpdateDate [new]: 2020-04-02 14:12:44\r\n'),
 (507,'2020-04-02 14:17:22','::1','admin','config','edit','---Keys\r\nidconfig : 4\r\n---Fields\r\nvalue [old]: ../Documentos/Workflow2/\r\nvalue [new]: files/Document\r\n'),
 (508,'2020-04-02 14:17:35','::1','admin','config','edit','---Keys\r\nidconfig : 4\r\n---Fields\r\nvalue [old]: files/Document\r\nvalue [new]: files/document\r\n'),
 (509,'2020-04-02 14:17:45','::1','admin','user','logout',''),
 (510,'2020-04-02 14:17:57','::1','admin','user','login',''),
 (511,'2020-04-02 14:21:01','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (512,'2020-04-02 14:21:12','::1','admin','document','delete','---Keys\r\niddocument : 19\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000021/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-02 14:12:51\r\nlastUpdateDate [old]: 2020-04-02 14:12:51\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"../Documentos/Workflow2/EX04_000008_2020/Peticion_20200402141251.docx\",\"usrName\":\"Peticion_20200402141251.docx\",\"size\":14190,\"type\":\"application/word\"}]\r\n'),
 (513,'2020-04-02 14:21:21','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-02 14:12:44\r\nlastUpdateDate [new]: 2020-04-02 14:21:16\r\n'),
 (514,'2020-04-02 14:21:30','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-02 14:21:16\r\nlastUpdateDate [new]: 2020-04-02 14:21:24\r\n'),
 (515,'2020-04-02 14:23:18','::1','admin','document','delete','---Keys\r\niddocument : 20\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000022/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-02 14:21:30\r\nlastUpdateDate [old]: 2020-04-02 14:21:30\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000008_2020/Peticion_20200402142130.docx\",\"usrName\":\"Peticion_20200402142130.docx\",\"size\":14190,\"type\":\"application/word\"}]\r\n'),
 (516,'2020-04-02 14:23:26','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-02 14:21:24\r\nlastUpdateDate [new]: 2020-04-02 14:23:22\r\n'),
 (517,'2020-04-02 14:23:34','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-02 14:23:22\r\nlastUpdateDate [new]: 2020-04-02 14:23:29\r\n'),
 (518,'2020-04-02 18:58:14','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-02 12:34:23\r\nlastUpdateDate [new]: 2020-04-02 18:58:07\r\n'),
 (519,'2020-04-02 18:58:32','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-02 18:58:07\r\nlastUpdateDate [new]: 2020-04-02 18:58:21\r\n'),
 (520,'2020-04-02 19:04:38','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_i8no4kg0.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":1427,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_cb350ox0.docx\",\"usrName\":\"plantilla ejemplo_\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/CondicionInformeEjemplo_w8dh2pd4.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":170,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nconditionFile [old]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_ahqu17vi.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":171,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nconditionFile [new]: \r\nlastUpdateDate [old]: 2020-04-01 20:41:58\r\nlastUpdateDate [new]: 2020-04-02 19:04:38\r\n'),
 (521,'2020-04-02 19:11:36','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/CondicionInformeEjemplo_w8dh2pd4.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":170,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_a0nwr07l.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":956,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_jicjw059.docx\",\"usrName\":\"plantilla ejemplo_1\r\nconditionFile [old]: \r\nconditionFile [new]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_p49amrd7.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":318,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-02 19:04:38\r\nlastUpdateDate [new]: 2020-04-02 19:11:36\r\n'),
 (522,'2020-04-03 13:40:32','::1','admin','user','add','---Keys\r\niduser : 4\r\n---Fields\r\nlogin [new]: boss1\r\npassword [new]: c333ba0d6e308bdb32ce3f2785301ae8\r\nNameAndSurname [new]: Boos 1\r\nemail [new]: info@fhumanes.com\r\nchief_iduser [new]: 1\r\nactive [new]: 1\r\nlastProcessWorked [new]: 1\r\n'),
 (523,'2020-04-03 13:40:50','::1','admin','user','edit','---Keys\r\niduser : 2\r\n---Fields\r\nchief_iduser [old]: 1\r\nchief_iduser [new]: 4\r\n'),
 (524,'2020-04-03 13:40:58','::1','admin','user','edit','---Keys\r\niduser : 3\r\n---Fields\r\nchief_iduser [old]: 1\r\nchief_iduser [new]: 4\r\n'),
 (525,'2020-04-03 13:41:14','::1','admin','user','edit','---Keys\r\niduser : 1\r\n---Fields\r\nchief_iduser [old]: \r\nchief_iduser [new]: 1\r\n'),
 (526,'2020-04-03 13:57:19','::1','admin','user','login',''),
 (527,'2020-04-03 13:57:22','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (528,'2020-04-03 14:00:57','::1','admin','ex04_expedient','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-02 18:58:21\r\nlastUpdateDate [new]: 2020-04-03 14:00:49\r\nex04_advanceAmount [old]: 0.00\r\nex04_advanceAmount [new]: 3000\r\n'),
 (529,'2020-04-03 14:01:22','::1','admin','ex04_expedient','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-02 14:23:29\r\nlastUpdateDate [new]: 2020-04-03 14:01:14\r\nex04_advanceAmount [old]: 0.00\r\nex04_advanceAmount [new]: 3500\r\n'),
 (530,'2020-04-03 14:19:03','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 5\r\nlastUpdateDate [old]: 2020-04-03 14:00:49\r\nlastUpdateDate [new]: 2020-04-03 14:18:36\r\n'),
 (531,'2020-04-03 14:19:15','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 5\r\nct_status_idct_status [new]: 6\r\nlastUpdateDate [old]: 2020-04-03 14:18:36\r\nlastUpdateDate [new]: 2020-04-03 14:19:07\r\n'),
 (532,'2020-04-03 14:20:25','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 6\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-03 14:19:07\r\nlastUpdateDate [new]: 2020-04-03 14:20:19\r\n'),
 (533,'2020-04-03 14:20:37','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 14:20:19\r\nlastUpdateDate [new]: 2020-04-03 14:20:29\r\n'),
 (534,'2020-04-03 14:20:48','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 14:20:29\r\nlastUpdateDate [new]: 2020-04-03 14:20:42\r\n'),
 (535,'2020-04-03 14:21:00','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 5\r\nlastUpdateDate [old]: 2020-04-03 14:20:42\r\nlastUpdateDate [new]: 2020-04-03 14:20:55\r\n'),
 (536,'2020-04-03 14:21:08','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 5\r\nct_status_idct_status [new]: 6\r\nlastUpdateDate [old]: 2020-04-03 14:20:55\r\nlastUpdateDate [new]: 2020-04-03 14:21:03\r\n'),
 (537,'2020-04-03 14:21:36','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 6\r\nct_status_idct_status [new]: 7\r\nlastUpdateDate [old]: 2020-04-03 14:21:03\r\nlastUpdateDate [new]: 2020-04-03 14:21:11\r\nfinishDate [old]: \r\nfinishDate [new]: 2020-04-03 14:21:26\r\n'),
 (538,'2020-04-03 17:28:21','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 7\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-03 14:21:11\r\nlastUpdateDate [new]: 2020-04-03 17:28:12\r\n'),
 (539,'2020-04-03 17:32:21','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nassignedUser [old]: \r\nassignedUser [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 17:28:12\r\nlastUpdateDate [new]: 2020-04-03 17:32:04\r\n'),
 (540,'2020-04-03 17:32:53','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nassignedUser [old]: 4\r\nassignedUser [new]: \r\nlastUpdateDate [old]: 2020-04-03 17:32:04\r\nlastUpdateDate [new]: 2020-04-03 17:32:48\r\n'),
 (541,'2020-04-03 17:33:15','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nassignedUser [old]: \r\nassignedUser [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 17:32:48\r\nlastUpdateDate [new]: 2020-04-03 17:33:05\r\n'),
 (542,'2020-04-03 17:34:20','::1','admin','access_group','edit','---Keys\r\nidaccess_group : 4\r\n---Fields\r\ncanAddExpedient [old]: 1\r\ncanAddExpedient [new]: 0\r\ncanEditExpedient [old]: 1\r\ncanEditExpedient [new]: 0\r\n'),
 (543,'2020-04-03 17:34:25','::1','admin','user','logout',''),
 (544,'2020-04-03 17:34:31','::1','admin','user','login',''),
 (545,'2020-04-03 17:34:34','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (546,'2020-04-03 17:35:58','::1','admin','access_group','edit','---Keys\r\nidaccess_group : 4\r\n---Fields\r\ncanAddExpedient [old]: 0\r\ncanAddExpedient [new]: 1\r\ncanEditExpedient [old]: 0\r\ncanEditExpedient [new]: 1\r\n'),
 (547,'2020-04-03 17:36:01','::1','admin','user','logout',''),
 (548,'2020-04-03 17:36:07','::1','admin','user','login',''),
 (549,'2020-04-03 17:36:09','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (550,'2020-04-03 17:37:12','::1','admin','ex04_expedient','add','---Keys\r\nidexpedient : 3\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_status_idct_status [new]: 1\r\ncodeExpedient [new]: EX04/000017/2020\r\ntitle [new]: Test 5\r\nobservations [new]: Observation ......\r\ncreationDate [new]: 2020-04-03 17:36:13\r\ncreationUser [new]: 1\r\nlastUpdateDate [new]: 2020-04-03 17:36:13\r\nlastUpdateUser [new]: 1\r\nex04_advanceAmount [new]: 4000\r\n'),
 (551,'2020-04-03 18:00:58','::1','admin','user','logout',''),
 (552,'2020-04-03 18:01:06','::1','boss1','user','login',''),
 (553,'2020-04-03 18:01:09','::1','boss1','select_process','edit','---Keys\r\niduser : 4\r\n'),
 (554,'2020-04-03 18:04:31','::1','boss1','user','logout',''),
 (555,'2020-04-03 18:04:42','::1','admin','user','login',''),
 (556,'2020-04-03 18:04:44','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (557,'2020-04-03 18:05:06','::1','admin','user_group','add','---Keys\r\niduser_group : 6\r\n---Fields\r\nuser_iduser [new]: 4\r\naccess_group_idaccess_group [new]: 1\r\n'),
 (558,'2020-04-03 18:10:39','::1','admin','user','logout',''),
 (559,'2020-04-03 18:10:49','::1','boss1','user','login',''),
 (560,'2020-04-03 18:10:51','::1','boss1','select_process','edit','---Keys\r\niduser : 4\r\n'),
 (561,'2020-04-03 18:11:22','::1','boss1','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nassignedUser [old]: 4\r\nassignedUser [new]: \r\nlastUpdateDate [old]: 2020-04-03 17:33:05\r\nlastUpdateDate [new]: 2020-04-03 18:11:13\r\nlastUpdateUser [old]: 1\r\nlastUpdateUser [new]: 4\r\n'),
 (562,'2020-04-03 18:34:55','::1','boss1','user','logout',''),
 (563,'2020-04-03 18:35:00','::1','admin','user','login',''),
 (564,'2020-04-03 18:35:02','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (565,'2020-04-03 18:37:51','::1','admin','ex04_expedient','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\ncreationUser [old]: 1\r\ncreationUser [new]: user1\r\nlastUpdateDate [old]: 2020-04-03 18:11:13\r\nlastUpdateDate [new]: 2020-04-03 18:37:43\r\nlastUpdateUser [old]: 4\r\nlastUpdateUser [new]: admin\r\n'),
 (566,'2020-04-03 18:38:08','::1','admin','ex04_expedient','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\ncreationUser [old]: 1\r\ncreationUser [new]: user2\r\nlastUpdateDate [old]: 2020-04-03 14:01:14\r\nlastUpdateDate [new]: 2020-04-03 18:38:00\r\nlastUpdateUser [old]: 1\r\nlastUpdateUser [new]: admin\r\n'),
 (567,'2020-04-03 18:38:22','::1','admin','ex04_expedient','edit','---Keys\r\nidexpedient : 3\r\n---Fields\r\ncreationUser [old]: 1\r\ncreationUser [new]: user1\r\nlastUpdateDate [old]: 2020-04-03 17:36:13\r\nlastUpdateDate [new]: 2020-04-03 18:38:16\r\nlastUpdateUser [old]: 1\r\nlastUpdateUser [new]: admin\r\n'),
 (568,'2020-04-03 18:38:32','::1','admin','user','logout',''),
 (569,'2020-04-03 18:38:41','::1','boss1','user','failed login',''),
 (570,'2020-04-03 18:38:45','::1','boss1','user','login',''),
 (571,'2020-04-03 18:38:47','::1','boss1','select_process','edit','---Keys\r\niduser : 4\r\n'),
 (572,'2020-04-03 18:39:14','::1','boss1','ex04_proceeding','edit','---Keys\r\nidexpedient : 3\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 18:38:16\r\nlastUpdateDate [new]: 2020-04-03 18:39:04\r\nlastUpdateUser [old]: admin\r\nlastUpdateUser [new]: boss1\r\n'),
 (573,'2020-04-03 18:40:38','::1','boss1','user','logout',''),
 (574,'2020-04-03 18:40:43','::1','admin','user','login',''),
 (575,'2020-04-03 18:40:45','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (576,'2020-04-03 20:33:24','::1','admin','ct_report','add','---Keys\r\nidct_report : 3\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_proceeding_idct_proceeding [new]: 2\r\ntitle [new]: Excel_peticion\r\nisPHPExcel [new]: 1\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_oos13yrk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10513,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_8hu74vv9.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [new]: 2020-04-03 20:32:39\r\nlastUpdateUser [new]: admin\r\n'),
 (577,'2020-04-03 20:33:55','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 18:37:43\r\nlastUpdateDate [new]: 2020-04-03 20:33:49\r\n'),
 (578,'2020-04-03 20:35:21','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 20:33:49\r\nlastUpdateDate [new]: 2020-04-03 20:35:14\r\n'),
 (579,'2020-04-03 20:35:47','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 20:35:14\r\nlastUpdateDate [new]: 2020-04-03 20:35:25\r\n'),
 (580,'2020-04-03 20:37:46','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 20:35:25\r\nlastUpdateDate [new]: 2020-04-03 20:37:27\r\n'),
 (581,'2020-04-03 20:38:29','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 20:37:27\r\nlastUpdateDate [new]: 2020-04-03 20:38:19\r\n'),
 (582,'2020-04-03 20:39:56','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 20:38:19\r\nlastUpdateDate [new]: 2020-04-03 20:39:50\r\n'),
 (583,'2020-04-03 20:40:09','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 20:39:50\r\nlastUpdateDate [new]: 2020-04-03 20:40:02\r\n'),
 (584,'2020-04-03 20:45:45','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 20:40:02\r\nlastUpdateDate [new]: 2020-04-03 20:45:35\r\n'),
 (585,'2020-04-03 20:48:03','::1','admin','config','add','---Keys\r\nidconfig : 5\r\n---Fields\r\nname [new]: DOCUMENT_ROOT_WF2\r\nvalue [new]: C:/Apache24/htdocs/workflow2/\r\n'),
 (586,'2020-04-03 20:50:20','::1','admin','user','logout',''),
 (587,'2020-04-03 20:50:32','::1','admin','user','login',''),
 (588,'2020-04-03 20:50:34','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (589,'2020-04-03 20:50:51','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 20:45:35\r\nlastUpdateDate [new]: 2020-04-03 20:50:44\r\n'),
 (590,'2020-04-03 20:54:25','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 20:50:44\r\nlastUpdateDate [new]: 2020-04-03 20:54:19\r\n'),
 (591,'2020-04-03 20:54:36','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 20:54:19\r\nlastUpdateDate [new]: 2020-04-03 20:54:30\r\n'),
 (592,'2020-04-03 21:01:04','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_oos13yrk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10513,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_8hu74vv9.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/CondicionInformeEjemplo_xa9ofzdv.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":318,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-03 20:32:39\r\nlastUpdateDate [new]: 2020-04-03 21:01:04\r\n'),
 (593,'2020-04-03 21:01:21','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/CondicionInformeEjemplo_xa9ofzdv.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":318,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_ikinclxp.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_a8tda0t4.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-03 21:01:04\r\nlastUpdateDate [new]: 2020-04-03 21:01:21\r\n'),
 (594,'2020-04-03 21:01:43','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 20:54:30\r\nlastUpdateDate [new]: 2020-04-03 21:01:35\r\n'),
 (595,'2020-04-03 21:01:55','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 21:01:35\r\nlastUpdateDate [new]: 2020-04-03 21:01:48\r\n'),
 (596,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 32\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000039/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 21:01:55\r\nlastUpdateDate [old]: 2020-04-03 21:01:55\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200403210155.xlsx\",\"usrName\":\"Excel_peticion_20200403210155.xlsx\",\"size\":10075,\"type\":\"application/excel\"}]\r\n'),
 (597,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 31\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000038/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 21:01:55\r\nlastUpdateDate [old]: 2020-04-03 21:01:55\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403210155.docx\",\"usrName\":\"Peticion_20200403210155.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (598,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 30\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000037/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:55:59\r\nlastUpdateDate [old]: 2020-04-03 20:55:59\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200403205437.xlsx\",\"usrName\":\"Excel_peticion_20200403205437.xlsx\",\"size\":10051,\"type\":\"application/excel\"}]\r\n'),
 (599,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 29\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000036/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:54:37\r\nlastUpdateDate [old]: 2020-04-03 20:54:37\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403205436.docx\",\"usrName\":\"Peticion_20200403205436.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (600,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 28\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000034/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:50:52\r\nlastUpdateDate [old]: 2020-04-03 20:50:52\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403205051.docx\",\"usrName\":\"Peticion_20200403205051.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (601,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 27\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000032/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:40:09\r\nlastUpdateDate [old]: 2020-04-03 20:40:09\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403204009.docx\",\"usrName\":\"Peticion_20200403204009.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (602,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 26\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000030/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:38:29\r\nlastUpdateDate [old]: 2020-04-03 20:38:29\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403203829.docx\",\"usrName\":\"Peticion_20200403203829.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (603,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 25\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000028/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:36:03\r\nlastUpdateDate [old]: 2020-04-03 20:36:03\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403203603.docx\",\"usrName\":\"Peticion_20200403203603.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (604,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 24\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000026/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 20:33:55\r\nlastUpdateDate [old]: 2020-04-03 20:33:55\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403203355.docx\",\"usrName\":\"Peticion_20200403203355.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (605,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 23\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000025/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 14:20:48\r\nlastUpdateDate [old]: 2020-04-03 14:20:48\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403142048.docx\",\"usrName\":\"Peticion_20200403142048.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (606,'2020-04-03 21:03:09','::1','admin','document','delete','---Keys\r\niddocument : 22\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000024/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-02 18:58:32\r\nlastUpdateDate [old]: 2020-04-02 18:58:32\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200402185832.docx\",\"usrName\":\"Peticion_20200402185832.docx\",\"size\":14190,\"type\":\"application/word\"}]\r\n'),
 (607,'2020-04-03 21:04:44','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 21:01:48\r\nlastUpdateDate [new]: 2020-04-03 21:04:37\r\n'),
 (608,'2020-04-03 21:04:56','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-03 21:04:37\r\nlastUpdateDate [new]: 2020-04-03 21:04:48\r\n'),
 (609,'2020-04-04 14:05:54','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_a0nwr07l.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":956,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_jicjw059.docx\",\"usrName\":\"plantilla ejemplo_1\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_hoavrqzv.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-02 19:11:36\r\nlastUpdateDate [new]: 2020-04-04 14:05:54\r\n'),
 (610,'2020-04-04 14:06:12','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_hoavrqzv.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nlastUpdateDate [old]: 2020-04-04 14:05:54\r\nlastUpdateDate [new]: 2020-04-04 14:06:12\r\n'),
 (611,'2020-04-04 14:06:22','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 21:04:48\r\nlastUpdateDate [new]: 2020-04-04 14:06:17\r\n'),
 (612,'2020-04-04 14:06:31','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 14:06:17\r\nlastUpdateDate [new]: 2020-04-04 14:06:24\r\n'),
 (613,'2020-04-04 14:07:53','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 14:06:12\r\nlastUpdateDate [new]: 2020-04-04 14:07:53\r\n'),
 (614,'2020-04-04 14:08:27','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nlastUpdateDate [old]: 2020-04-04 14:07:53\r\nlastUpdateDate [new]: 2020-04-04 14:08:27\r\n');
INSERT INTO `wf2_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (615,'2020-04-04 14:08:35','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 14:06:24\r\nlastUpdateDate [new]: 2020-04-04 14:08:31\r\n'),
 (616,'2020-04-04 14:08:47','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 14:08:31\r\nlastUpdateDate [new]: 2020-04-04 14:08:39\r\n'),
 (617,'2020-04-04 14:09:33','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 14:08:27\r\nlastUpdateDate [new]: 2020-04-04 14:09:33\r\n'),
 (618,'2020-04-04 14:09:47','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nlastUpdateDate [old]: 2020-04-04 14:09:33\r\nlastUpdateDate [new]: 2020-04-04 14:09:47\r\n'),
 (619,'2020-04-04 14:09:54','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 14:08:39\r\nlastUpdateDate [new]: 2020-04-04 14:09:50\r\n'),
 (620,'2020-04-04 14:10:03','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 14:09:50\r\nlastUpdateDate [new]: 2020-04-04 14:09:57\r\n'),
 (621,'2020-04-04 14:12:16','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 14:09:57\r\nlastUpdateDate [new]: 2020-04-04 14:12:10\r\n'),
 (622,'2020-04-04 14:12:34','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 14:12:10\r\nlastUpdateDate [new]: 2020-04-04 14:12:28\r\n'),
 (623,'2020-04-04 14:15:59','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_q90lxlle.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15478,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 14:09:47\r\nlastUpdateDate [new]: 2020-04-04 14:15:59\r\n'),
 (624,'2020-04-04 14:16:12','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_mra9pqyj.docx\",\"usrName\":\"plantilla ejemplo_\r\nlastUpdateDate [old]: 2020-04-04 14:15:59\r\nlastUpdateDate [new]: 2020-04-04 14:16:12\r\n'),
 (625,'2020-04-04 14:16:23','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 14:12:28\r\nlastUpdateDate [new]: 2020-04-04 14:16:18\r\n'),
 (626,'2020-04-04 14:16:35','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 14:16:18\r\nlastUpdateDate [new]: 2020-04-04 14:16:28\r\n'),
 (627,'2020-04-04 14:17:58','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_mra9pqyj.docx\",\"usrName\":\"plantilla ejemplo_\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 14:16:12\r\nlastUpdateDate [new]: 2020-04-04 14:17:58\r\n'),
 (628,'2020-04-04 14:18:11','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_\r\nlastUpdateDate [old]: 2020-04-04 14:17:58\r\nlastUpdateDate [new]: 2020-04-04 14:18:11\r\n'),
 (629,'2020-04-04 14:18:21','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 14:16:28\r\nlastUpdateDate [new]: 2020-04-04 14:18:15\r\n'),
 (630,'2020-04-04 14:18:32','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 14:18:15\r\nlastUpdateDate [new]: 2020-04-04 14:18:25\r\n'),
 (631,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 40\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000049/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:16:53\r\nlastUpdateDate [old]: 2020-04-04 14:16:53\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404141653.xlsx\",\"usrName\":\"Excel_peticion_20200404141653.xlsx\",\"size\":10078,\"type\":\"application/excel\"}]\r\n'),
 (632,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 39\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000048/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:16:53\r\nlastUpdateDate [old]: 2020-04-04 14:16:53\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404141635.docx\",\"usrName\":\"Peticion_20200404141635.docx\",\"size\":14222,\"type\":\"application/word\"}]\r\n'),
 (633,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 38\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000047/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:14:31\r\nlastUpdateDate [old]: 2020-04-04 14:14:31\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404141431.xlsx\",\"usrName\":\"Excel_peticion_20200404141431.xlsx\",\"size\":10078,\"type\":\"application/excel\"}]\r\n'),
 (634,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 37\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000046/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:14:31\r\nlastUpdateDate [old]: 2020-04-04 14:14:31\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404141234.docx\",\"usrName\":\"Peticion_20200404141234.docx\",\"size\":14198,\"type\":\"application/word\"}]\r\n'),
 (635,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 36\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000045/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:10:04\r\nlastUpdateDate [old]: 2020-04-04 14:10:04\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404141003.xlsx\",\"usrName\":\"Excel_peticion_20200404141003.xlsx\",\"size\":10077,\"type\":\"application/excel\"}]\r\n'),
 (636,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 35\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000044/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:10:03\r\nlastUpdateDate [old]: 2020-04-04 14:10:03\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404141003.docx\",\"usrName\":\"Peticion_20200404141003.docx\",\"size\":14198,\"type\":\"application/word\"}]\r\n'),
 (637,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 34\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000041/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 21:04:56\r\nlastUpdateDate [old]: 2020-04-03 21:04:56\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200403210456.xlsx\",\"usrName\":\"Excel_peticion_20200403210456.xlsx\",\"size\":10076,\"type\":\"application/excel\"}]\r\n'),
 (638,'2020-04-04 14:19:17','::1','admin','document','delete','---Keys\r\niddocument : 33\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000040/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-03 21:04:56\r\nlastUpdateDate [old]: 2020-04-03 21:04:56\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200403210456.docx\",\"usrName\":\"Peticion_20200403210456.docx\",\"size\":14154,\"type\":\"application/word\"}]\r\n'),
 (639,'2020-04-04 17:02:01','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 14:18:25\r\nlastUpdateDate [new]: 2020-04-04 17:01:56\r\n'),
 (640,'2020-04-04 17:02:09','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 17:01:56\r\nlastUpdateDate [new]: 2020-04-04 17:02:04\r\n'),
 (641,'2020-04-04 17:04:06','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 17:02:04\r\nlastUpdateDate [new]: 2020-04-04 17:04:01\r\n'),
 (642,'2020-04-04 17:04:25','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 17:04:01\r\nlastUpdateDate [new]: 2020-04-04 17:04:09\r\n'),
 (643,'2020-04-04 17:04:59','::1','admin','document','delete','---Keys\r\niddocument : 42\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000051/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:18:33\r\nlastUpdateDate [old]: 2020-04-04 14:18:33\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404141832.xlsx\",\"usrName\":\"Excel_peticion_20200404141832.xlsx\",\"size\":10078,\"type\":\"application/excel\"}]\r\n'),
 (644,'2020-04-04 17:04:59','::1','admin','document','delete','---Keys\r\niddocument : 41\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000050/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 14:18:32\r\nlastUpdateDate [old]: 2020-04-04 14:18:32\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404141832.docx\",\"usrName\":\"Peticion_20200404141832.docx\",\"size\":14204,\"type\":\"application/word\"}]\r\n'),
 (645,'2020-04-04 17:36:09','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 1\r\nlastUpdateDate [old]: 2020-04-04 17:04:09\r\nlastUpdateDate [new]: 2020-04-04 17:35:35\r\n'),
 (646,'2020-04-04 17:36:23','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 1\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 17:35:35\r\nlastUpdateDate [new]: 2020-04-04 17:36:14\r\n'),
 (647,'2020-04-04 17:36:38','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 17:36:14\r\nlastUpdateDate [new]: 2020-04-04 17:36:29\r\n'),
 (648,'2020-04-04 17:37:25','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 17:36:29\r\nlastUpdateDate [new]: 2020-04-04 17:37:17\r\n'),
 (649,'2020-04-04 17:37:34','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 17:37:17\r\nlastUpdateDate [new]: 2020-04-04 17:37:28\r\n'),
 (650,'2020-04-04 17:54:29','::1','admin','ct_utility','edit','---Keys\r\nidct_utility : 2\r\n---Fields\r\nurlUtility [old]: list\r\nurlUtility [new]: ex04_report_edit.php\r\n'),
 (651,'2020-04-04 17:54:43','::1','admin','ct_utility','edit','---Keys\r\nidct_utility : 3\r\n---Fields\r\nurlUtility [old]: print\r\nurlUtility [new]: ex04_report_edit.php\r\n'),
 (652,'2020-04-04 19:32:09','::1','admin','ct_report','add','---Keys\r\nidct_report : 4\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_utility_idct_utility [new]: 2\r\ntitle [new]: Listado\r\nisPHPExcel [new]: 1\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_f9xe0w0a.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [new]: 2020-04-04 19:31:40\r\nlastUpdateUser [new]: admin\r\n'),
 (653,'2020-04-04 20:15:06','::1','admin','user','logout',''),
 (654,'2020-04-04 20:15:14','::1','admin','user','login',''),
 (655,'2020-04-04 20:15:17','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (656,'2020-04-04 20:28:21','::1','admin','user','login',''),
 (657,'2020-04-04 20:28:25','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (658,'2020-04-04 20:39:54','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 17:37:28\r\nlastUpdateDate [new]: 2020-04-04 20:39:48\r\n'),
 (659,'2020-04-04 20:40:08','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-04 20:39:48\r\nlastUpdateDate [new]: 2020-04-04 20:39:58\r\n'),
 (660,'2020-04-04 20:52:11','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\nct_utility_idct_utility [old]: 2\r\nct_utility_idct_utility [new]: 3\r\nlastUpdateDate [old]: 2020-04-04 19:31:40\r\nlastUpdateDate [new]: 2020-04-04 20:52:10\r\n'),
 (661,'2020-04-04 20:52:34','::1','admin','ct_report','add','---Keys\r\nidct_report : 5\r\n---Fields\r\nprocess_idprocess [new]: 1\r\nct_utility_idct_utility [new]: 2\r\nisPHPWord [new]: 1\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_869kdkor.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nconditionFile [new]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_ndcmvf5y.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":318,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [new]: 2020-04-04 20:52:13\r\nlastUpdateUser [new]: admin\r\n'),
 (662,'2020-04-04 21:09:56','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_f9xe0w0a.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 20:52:10\r\nlastUpdateDate [new]: 2020-04-04 21:09:56\r\n'),
 (663,'2020-04-04 21:10:14','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_0njg6zkf.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-04 21:09:56\r\nlastUpdateDate [new]: 2020-04-04 21:10:14\r\n'),
 (664,'2020-04-04 21:12:01','::1','admin','user','logout',''),
 (665,'2020-04-05 12:38:12','::1','admin','user','login',''),
 (666,'2020-04-05 12:38:17','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (667,'2020-04-05 12:41:06','::1','admin','ex04_expedient','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nobservations [old]: Observacion\r\nobservations [new]: Observacion. Texto en varias líneas para ver los efectos en la exportación a Excel. Saludos, \r\nlastUpdateDate [old]: 2020-04-04 20:39:58\r\nlastUpdateDate [new]: 2020-04-05 12:40:28\r\n'),
 (668,'2020-04-05 12:41:30','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-05 12:40:28\r\nlastUpdateDate [new]: 2020-04-05 12:41:25\r\n'),
 (669,'2020-04-05 12:41:43','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-05 12:41:25\r\nlastUpdateDate [new]: 2020-04-05 12:41:34\r\n'),
 (670,'2020-04-05 13:03:19','::1','admin','user','login',''),
 (671,'2020-04-05 13:03:36','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_0njg6zkf.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 21:10:14\r\nlastUpdateDate [new]: 2020-04-05 13:03:36\r\n'),
 (672,'2020-04-05 13:03:54','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_rgddqk4f.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-05 13:03:36\r\nlastUpdateDate [new]: 2020-04-05 13:03:54\r\n'),
 (673,'2020-04-05 13:08:24','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_rgddqk4f.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 13:03:54\r\nlastUpdateDate [new]: 2020-04-05 13:08:24\r\n'),
 (674,'2020-04-05 13:08:47','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_ucdrxlpi.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-05 13:08:24\r\nlastUpdateDate [new]: 2020-04-05 13:08:47\r\n'),
 (675,'2020-04-05 13:22:11','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_ucdrxlpi.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 13:08:47\r\nlastUpdateDate [new]: 2020-04-05 13:22:11\r\n'),
 (676,'2020-04-05 13:22:34','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_h9ohkmfd.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-05 13:22:11\r\nlastUpdateDate [new]: 2020-04-05 13:22:34\r\n'),
 (677,'2020-04-05 13:28:51','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_h9ohkmfd.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 13:22:34\r\nlastUpdateDate [new]: 2020-04-05 13:28:51\r\n'),
 (678,'2020-04-05 13:29:17','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_gr1axvxy.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-05 13:28:51\r\nlastUpdateDate [new]: 2020-04-05 13:29:17\r\n'),
 (679,'2020-04-05 13:31:52','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_vlijw2mm.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_gr1axvxy.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_gr1axvxy.php\",\"usrName\":\"modelo_2.php\",\"size\":4190,\"type\":\"text\\/html\",\"searchStr\":\"modelo_2.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 13:29:17\r\nlastUpdateDate [new]: 2020-04-05 13:31:52\r\n'),
 (680,'2020-04-05 13:32:07','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_gr1axvxy.php\",\"usrName\":\"modelo_2.php\",\"size\":4190,\"type\":\"text\\/html\",\"searchStr\":\"modelo_2.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_gr1axvxy.php\",\"usrName\":\"modelo_2.php\",\"size\":4190,\"type\":\"text\\/html\",\"searchStr\":\"modelo_2.php,!modelo_2.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-offic\r\nlastUpdateDate [old]: 2020-04-05 13:31:52\r\nlastUpdateDate [new]: 2020-04-05 13:32:07\r\n'),
 (681,'2020-04-05 13:33:31','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_ikinclxp.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10554,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_a8tda0t4.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_a8tda0t4.php\",\"usrName\":\"modelo_2.php\",\"size\":3873,\"type\":\"text\\/html\",\"searchStr\":\"modelo_2.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-03 21:01:21\r\nlastUpdateDate [new]: 2020-04-05 13:33:31\r\n'),
 (682,'2020-04-05 13:34:03','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ntitle [old]: Excel_peticion\r\ntitle [new]: Report_Expedient\r\nlastUpdateDate [old]: 2020-04-05 13:33:31\r\nlastUpdateDate [new]: 2020-04-05 13:34:03\r\n'),
 (683,'2020-04-05 13:34:21','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_a8tda0t4.php\",\"usrName\":\"modelo_2.php\",\"size\":3873,\"type\":\"text\\/html\",\"searchStr\":\"modelo_2.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 13:34:03\r\nlastUpdateDate [new]: 2020-04-05 13:34:21\r\n'),
 (684,'2020-04-05 13:34:32','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_qy9853fx.php\",\"usrName\":\"modelo_2.php\",\"\r\nlastUpdateDate [old]: 2020-04-05 13:34:21\r\nlastUpdateDate [new]: 2020-04-05 13:34:32\r\n'),
 (685,'2020-04-05 13:34:48','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-05 12:41:34\r\nlastUpdateDate [new]: 2020-04-05 13:34:43\r\n'),
 (686,'2020-04-05 13:35:02','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-05 13:34:43\r\nlastUpdateDate [new]: 2020-04-05 13:34:52\r\n'),
 (687,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 53\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000062/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-05 12:41:43\r\nlastUpdateDate [old]: 2020-04-05 12:41:43\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200405124143.docx\",\"usrName\":\"Peticion_20200405124143.docx\",\"size\":14202,\"type\":\"application/word\"}]\r\n'),
 (688,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 52\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000061/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 20:40:08\r\nlastUpdateDate [old]: 2020-04-04 20:40:08\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404204008.xlsx\",\"usrName\":\"Excel_peticion_20200404204008.xlsx\",\"size\":10077,\"type\":\"application/excel\"}]\r\n'),
 (689,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 51\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000060/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 20:40:08\r\nlastUpdateDate [old]: 2020-04-04 20:40:08\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404204008.docx\",\"usrName\":\"Peticion_20200404204008.docx\",\"size\":14202,\"type\":\"application/word\"}]\r\n'),
 (690,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 50\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000059/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:37:35\r\nlastUpdateDate [old]: 2020-04-04 17:37:35\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404173734.xlsx\",\"usrName\":\"Excel_peticion_20200404173734.xlsx\",\"size\":10076,\"type\":\"application/excel\"}]\r\n'),
 (691,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 49\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000058/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:37:34\r\nlastUpdateDate [old]: 2020-04-04 17:37:34\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404173734.docx\",\"usrName\":\"Peticion_20200404173734.docx\",\"size\":14204,\"type\":\"application/word\"}]\r\n'),
 (692,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 48\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000057/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:36:38\r\nlastUpdateDate [old]: 2020-04-04 17:36:38\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404173638.xlsx\",\"usrName\":\"Excel_peticion_20200404173638.xlsx\",\"size\":10078,\"type\":\"application/excel\"}]\r\n'),
 (693,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 47\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000056/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:36:38\r\nlastUpdateDate [old]: 2020-04-04 17:36:38\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404173638.docx\",\"usrName\":\"Peticion_20200404173638.docx\",\"size\":14202,\"type\":\"application/word\"}]\r\n'),
 (694,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 46\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000055/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:04:26\r\nlastUpdateDate [old]: 2020-04-04 17:04:26\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404170425.xlsx\",\"usrName\":\"Excel_peticion_20200404170425.xlsx\",\"size\":10078,\"type\":\"application/excel\"}]\r\n'),
 (695,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 45\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000054/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:04:25\r\nlastUpdateDate [old]: 2020-04-04 17:04:25\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404170425.docx\",\"usrName\":\"Peticion_20200404170425.docx\",\"size\":14202,\"type\":\"application/word\"}]\r\n'),
 (696,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 44\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000053/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:02:09\r\nlastUpdateDate [old]: 2020-04-04 17:02:09\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200404170209.xlsx\",\"usrName\":\"Excel_peticion_20200404170209.xlsx\",\"size\":10079,\"type\":\"application/excel\"}]\r\n'),
 (697,'2020-04-05 17:45:55','::1','admin','document','delete','---Keys\r\niddocument : 43\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000052/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-04 17:02:09\r\nlastUpdateDate [old]: 2020-04-04 17:02:09\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200404170209.docx\",\"usrName\":\"Peticion_20200404170209.docx\",\"size\":14204,\"type\":\"application/word\"}]\r\n'),
 (698,'2020-04-05 17:46:04','::1','admin','document','delete','---Keys\r\niddocument : 54\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000063/2020\r\nTitle [old]: Excel_peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-05 12:41:44\r\nlastUpdateDate [old]: 2020-04-05 12:41:44\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Excel_peticion_20200405124143.xlsx\",\"usrName\":\"Excel_peticion_20200405124143.xlsx\",\"size\":10156,\"type\":\"application/excel\"}]\r\n'),
 (699,'2020-04-05 18:29:47','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\nisPHPWord [old]: 1\r\nisPHPWord [new]: 0\r\nisPHPExcel [old]: 0\r\nisPHPExcel [new]: 1\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_869kdkor.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_4bnrb9b5.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10651,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"\r\nconditionFile [old]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_ndcmvf5y.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":318,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nconditionFile [new]: \r\nlastUpdateDate [old]: 2020-04-04 20:52:13\r\nlastUpdateDate [new]: 2020-04-05 18:29:47\r\n'),
 (700,'2020-04-05 19:14:25','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_4bnrb9b5.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10651,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 18:29:47\r\nlastUpdateDate [new]: 2020-04-05 19:14:25\r\n'),
 (701,'2020-04-05 19:15:12','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_p91t7wvv.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10683,\"type\":\"application\\/vnd.openxmlformats-offic\r\nlastUpdateDate [old]: 2020-04-05 19:14:25\r\nlastUpdateDate [new]: 2020-04-05 19:15:12\r\n'),
 (702,'2020-04-05 19:24:00','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_p91t7wvv.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10683,\"type\":\"application\\/vnd.openxmlformats-offic\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 19:15:12\r\nlastUpdateDate [new]: 2020-04-05 19:24:00\r\n'),
 (703,'2020-04-05 19:25:09','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_1fka77tz.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10643,\"type\":\"application\\/vnd.openxmlformats-offic\r\nlastUpdateDate [old]: 2020-04-05 19:24:00\r\nlastUpdateDate [new]: 2020-04-05 19:25:09\r\n'),
 (704,'2020-04-05 19:28:28','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_1fka77tz.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10643,\"type\":\"application\\/vnd.openxmlformats-offic\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 19:25:09\r\nlastUpdateDate [new]: 2020-04-05 19:28:28\r\n'),
 (705,'2020-04-05 19:28:41','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_2ir8uqka.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10727,\"type\":\"application\\/vnd.openxmlformats-offic\r\nlastUpdateDate [old]: 2020-04-05 19:28:28\r\nlastUpdateDate [new]: 2020-04-05 19:28:41\r\n'),
 (706,'2020-04-05 19:30:49','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_2ir8uqka.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10727,\"type\":\"application\\/vnd.openxmlformats-offic\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 19:28:41\r\nlastUpdateDate [new]: 2020-04-05 19:30:49\r\n'),
 (707,'2020-04-05 19:31:10','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-offic\r\nlastUpdateDate [old]: 2020-04-05 19:30:49\r\nlastUpdateDate [new]: 2020-04-05 19:31:10\r\n'),
 (708,'2020-04-05 19:39:28','::1','admin','catalog','edit','---Keys\r\nidcatalog : 30\r\n---Fields\r\ncatalogCode [old]: Listado de expdientes\r\ncatalogCode [new]: Listado de exptes por Estado\r\ndescription [old]: Listado de expdientes\r\ndescription [new]: Listado de exptes por Estado\r\n'),
 (709,'2020-04-05 19:39:40','::1','admin','catalog','edit','---Keys\r\nidcatalog : 33\r\n---Fields\r\ncatalogCode [old]: List of records\r\ncatalogCode [new]: List of records for Status\r\n'),
 (710,'2020-04-05 19:45:55','::1','admin','user','logout',''),
 (711,'2020-04-06 12:05:28','::1','admin','user','login',''),
 (712,'2020-04-06 12:05:30','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (713,'2020-04-06 12:13:33','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_u5h58irq.php\",\"usrName\":\"modelo_3.php\",\"size\":7302,\"type\":\"text\\/html\",\"searchStr\":\"modelo_3.php,!modelo_3.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-offic\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-05 19:31:10\r\nlastUpdateDate [new]: 2020-04-06 12:13:33\r\n'),
 (714,'2020-04-06 12:13:45','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_uwy1es4a.php\",\"usrName\":\"modelo_3.php\",\"\r\nlastUpdateDate [old]: 2020-04-06 12:13:33\r\nlastUpdateDate [new]: 2020-04-06 12:13:45\r\n'),
 (715,'2020-04-06 12:15:38','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_uwy1es4a.php\",\"usrName\":\"modelo_3.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-06 12:13:45\r\nlastUpdateDate [new]: 2020-04-06 12:15:38\r\n'),
 (716,'2020-04-06 12:15:49','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_urdsyn69.php\",\"usrName\":\"modelo_3.php\",\"\r\nlastUpdateDate [old]: 2020-04-06 12:15:38\r\nlastUpdateDate [new]: 2020-04-06 12:15:49\r\n'),
 (717,'2020-04-06 12:42:50','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nlastUpdateDate [old]: 2020-04-05 13:34:52\r\nlastUpdateDate [new]: 2020-04-06 12:42:46\r\n'),
 (718,'2020-04-06 12:51:53','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 5\r\nlastUpdateDate [old]: 2020-04-06 12:42:46\r\nlastUpdateDate [new]: 2020-04-06 12:51:47\r\n'),
 (719,'2020-04-06 13:06:43','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (720,'2020-04-06 13:24:16','::1','admin','super_catalog','add','---Keys\r\nidsuper_catalog : 11\r\n---Fields\r\nsuperCode [new]: EX01_EXPENSE\r\ndescription [new]: Tipo de Gastos\r\n'),
 (721,'2020-04-06 13:25:10','::1','admin','catalog','add','---Keys\r\nidcatalog : 87\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Taxis\r\n'),
 (722,'2020-04-06 13:25:45','::1','admin','catalog','add','---Keys\r\nidcatalog : 88\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Gasolina o Diesel\r\n'),
 (723,'2020-04-06 13:25:57','::1','admin','catalog','add','---Keys\r\nidcatalog : 89\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Peajes\r\n'),
 (724,'2020-04-06 13:26:10','::1','admin','catalog','add','---Keys\r\nidcatalog : 90\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Aparcamientos\r\n'),
 (725,'2020-04-06 13:26:37','::1','admin','catalog','add','---Keys\r\nidcatalog : 91\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Desayunos, comidas y cenas\r\n'),
 (726,'2020-04-06 13:26:57','::1','admin','catalog','add','---Keys\r\nidcatalog : 92\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Invitaciones Clientes\r\n'),
 (727,'2020-04-06 13:27:09','::1','admin','catalog','add','---Keys\r\nidcatalog : 93\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Hoteles\r\n'),
 (728,'2020-04-06 13:27:43','::1','admin','catalog','add','---Keys\r\nidcatalog : 94\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Taxis\r\n'),
 (729,'2020-04-06 13:28:15','::1','admin','catalog','add','---Keys\r\nidcatalog : 95\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 2\r\ncatalogCode [new]: Petrol or Diesel\r\n'),
 (730,'2020-04-06 13:28:54','::1','admin','catalog','add','---Keys\r\nidcatalog : 96\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 3\r\ncatalogCode [new]: Tolls\r\n'),
 (731,'2020-04-06 13:29:37','::1','admin','catalog','add','---Keys\r\nidcatalog : 97\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 4\r\ncatalogCode [new]: Parking\r\n'),
 (732,'2020-04-06 13:30:07','::1','admin','catalog','add','---Keys\r\nidcatalog : 98\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 5\r\ncatalogCode [new]: Breakfasts, lunches and dinners\r\n'),
 (733,'2020-04-06 13:30:34','::1','admin','catalog','add','---Keys\r\nidcatalog : 99\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 6\r\ncatalogCode [new]: Customer Invitations\r\n'),
 (734,'2020-04-06 13:30:59','::1','admin','catalog','add','---Keys\r\nidcatalog : 100\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 11\r\nlanguage [new]: English\r\ncatalogNum [new]: 7\r\ncatalogCode [new]: Hotels\r\n'),
 (735,'2020-04-06 13:34:51','::1','admin','user','login',''),
 (736,'2020-04-06 13:34:53','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (737,'2020-04-06 13:35:06','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (738,'2020-04-06 13:36:34','::1','admin','process','edit','---Keys\r\nidprocess : 2\r\n---Fields\r\nurlAdd [old]: DEDE\r\nurlAdd [new]: ex01_expedient_add.php\r\nurlEdit [old]: DEDEDE\r\nurlEdit [new]: ex01_expedient_edit.php\r\nurlView [old]: DEDDE\r\nurlView [new]: ex04_expedient_view.php\r\n'),
 (739,'2020-04-06 13:37:01','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (740,'2020-04-06 13:37:26','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 7\r\n---Fields\r\nurlProceeding [old]: eedede\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (741,'2020-04-06 13:37:33','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 8\r\n---Fields\r\nurlProceeding [old]: ddede\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (742,'2020-04-06 13:37:39','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 9\r\n---Fields\r\nurlProceeding [old]: dedede\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (743,'2020-04-06 13:37:46','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 10\r\n---Fields\r\nurlProceeding [old]: ffrfrfr\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (744,'2020-04-06 13:37:59','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 11\r\n---Fields\r\nurlProceeding [old]: dedede\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (745,'2020-04-06 13:38:06','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 12\r\n---Fields\r\nurlProceeding [old]: frfrfr\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (746,'2020-04-06 13:38:13','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 13\r\n---Fields\r\nurlProceeding [old]: frfrfr\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (747,'2020-04-06 13:38:19','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 14\r\n---Fields\r\nurlProceeding [old]: deded\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (748,'2020-04-06 13:38:26','::1','admin','ct_proceeding','edit','---Keys\r\nidct_proceeding : 15\r\n---Fields\r\nurlProceeding [old]: frfr\r\nurlProceeding [new]: ex01_proceeding_edit.php\r\n'),
 (749,'2020-04-06 13:38:44','::1','admin','ct_report','delete','---Keys\r\nidct_report : 2\r\n---Fields\r\nprocess_idprocess [old]: 2\r\nct_proceeding_idct_proceeding [old]: 12\r\ntitle [old]: Proof of payment\r\nisPHPWord [old]: 1\r\nisPHPExcel [old]: 0\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo 1_6hw3kvmw.docx\",\"usrName\":\"plantilla ejemplo 1.docx\",\"size\":15152,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo 1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nconditionFile [old]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_8djs0043.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":146,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-02-09 20:46:53\r\nlastUpdateUser [old]: admin\r\n'),
 (750,'2020-04-06 14:20:57','::1','admin','ex01_expedient','add','---Keys\r\nidexpedient : 4\r\n---Fields\r\nprocess_idprocess [new]: 2\r\nct_status_idct_status [new]: 9\r\ncodeExpedient [new]: EX01/000001/2020\r\ntitle [new]: Test 1\r\nassignedUser [new]: 1\r\ncreationDate [new]: 2020-04-06 14:19:59\r\ncreationUser [new]: admin\r\nlastUpdateDate [new]: 2020-04-06 14:19:59\r\nlastUpdateUser [new]: admin\r\n'),
 (751,'2020-04-06 14:21:46','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (752,'2020-04-06 14:32:03','::1','admin','alerts','add','---Keys\r\nidalerts : 5\r\n---Fields\r\nexpedient_idexpedient [new]: 4\r\ncreationDate [new]: 2020-04-06 14:31:52\r\nalertDate [new]: 2020-04-03 00:00:00\r\nalertClass [new]: 0\r\nsituation [new]: 0\r\ncreationUser [new]: admin\r\nlastUpdateDate [new]: 2020-04-06 14:31:52\r\nlastUpdateUser [new]: admin\r\n'),
 (753,'2020-04-06 19:38:59','::1','admin','user','logout',''),
 (754,'2020-04-06 19:39:06','::1','admin','user','login',''),
 (755,'2020-04-06 19:39:11','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (756,'2020-04-06 19:40:41','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (757,'2020-04-06 19:41:12','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (758,'2020-04-06 19:42:00','::1','admin','user','login',''),
 (759,'2020-04-06 19:42:04','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (760,'2020-04-06 19:43:28','::1','admin','catalog','add','---Keys\r\nidcatalog : 101\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 7\r\nlanguage [new]: Spanish\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Modificar Expediente\r\n'),
 (761,'2020-04-06 19:44:08','::1','admin','catalog','add','---Keys\r\nidcatalog : 102\r\n---Fields\r\nsuper_catalog_idsuper_catalog [new]: 7\r\nlanguage [new]: English\r\ncatalogNum [new]: 1\r\ncatalogCode [new]: Updated Expedient\r\n'),
 (762,'2020-04-06 19:44:51','::1','admin','ct_utility','add','---Keys\r\nidct_utility : 4\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncatalogNum [new]: 1\r\nimportanceWeight [new]: 1\r\nurlUtility [new]: ex01_utility_edit.php\r\n'),
 (763,'2020-04-06 19:45:05','::1','admin','utility_group','add','---Keys\r\nidutility_group : 7\r\n---Fields\r\nct_utility_idct_utility [new]: 4\r\naccess_group_idaccess_group [new]: 5\r\n'),
 (764,'2020-04-06 20:29:25','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (765,'2020-04-06 20:31:34','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (766,'2020-04-06 20:42:05','::1','admin','ex01_proceeding','edit','---Keys\r\nidexpedient : 4\r\n---Fields\r\nct_status_idct_status [old]: 9\r\nct_status_idct_status [new]: 10\r\nassignedUser [old]: 1\r\nassignedUser [new]: \r\nlastUpdateDate [old]: 2020-04-06 14:19:59\r\nlastUpdateDate [new]: 2020-04-06 20:41:37\r\n'),
 (767,'2020-04-06 20:45:25','::1','admin','access_group','add','---Keys\r\nidaccess_group : 6\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncode [new]: Employee\r\ntitle [new]: Any Company Employee\r\ncanAddExpedient [new]: 1\r\ncanViewExpedient [new]: 1\r\n'),
 (768,'2020-04-06 20:46:08','::1','admin','user_group','add','---Keys\r\niduser_group : 7\r\n---Fields\r\nuser_iduser [new]: 2\r\naccess_group_idaccess_group [new]: 6\r\n'),
 (769,'2020-04-06 20:46:17','::1','admin','user_group','add','---Keys\r\niduser_group : 8\r\n---Fields\r\nuser_iduser [new]: 3\r\naccess_group_idaccess_group [new]: 6\r\n'),
 (770,'2020-04-06 20:46:46','::1','admin','user_group','add','---Keys\r\niduser_group : 9\r\n---Fields\r\nuser_iduser [new]: 4\r\naccess_group_idaccess_group [new]: 6\r\n'),
 (771,'2020-04-06 20:47:30','::1','admin','status_group','add','---Keys\r\nidstatus_group : 16\r\n---Fields\r\nct_status_idct_status [new]: 8\r\naccess_group_idaccess_group [new]: 6\r\n'),
 (772,'2020-04-06 20:47:39','::1','admin','status_group','add','---Keys\r\nidstatus_group : 17\r\n---Fields\r\nct_status_idct_status [new]: 9\r\naccess_group_idaccess_group [new]: 6\r\n'),
 (773,'2020-04-06 20:49:49','::1','admin','access_group','add','---Keys\r\nidaccess_group : 7\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncode [new]: RRHH\r\ntitle [new]: Human Resources\r\ncanViewExpedient [new]: 1\r\n'),
 (774,'2020-04-06 20:50:54','::1','admin','access_group','add','---Keys\r\nidaccess_group : 8\r\n---Fields\r\nprocess_idprocess [new]: 2\r\ncode [new]: Accounting\r\ntitle [new]: General accounting and cash\r\ncanViewExpedient [new]: 1\r\n'),
 (775,'2020-04-06 20:53:14','::1','admin','user','add','---Keys\r\niduser : 5\r\n---Fields\r\nlogin [new]: rrhh1\r\npassword [new]: a662d3f38582d19910487bbcc4e5ebdb\r\nNameAndSurname [new]: RRHH 1\r\nemail [new]: info@fhumanes.com\r\nchief_iduser [new]: 4\r\nactive [new]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (776,'2020-04-06 20:54:04','::1','admin','user','add','---Keys\r\niduser : 6\r\n---Fields\r\nlogin [new]: accounting1\r\npassword [new]: 9fe53c4adeac1691021662f165c72eea\r\nNameAndSurname [new]: Accounting 1\r\nemail [new]: info@fhumanes.com\r\nchief_iduser [new]: 4\r\nactive [new]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (777,'2020-04-06 20:54:28','::1','admin','user_group','add','---Keys\r\niduser_group : 10\r\n---Fields\r\nuser_iduser [new]: 5\r\naccess_group_idaccess_group [new]: 7\r\n'),
 (778,'2020-04-06 20:54:37','::1','admin','user_group','add','---Keys\r\niduser_group : 11\r\n---Fields\r\nuser_iduser [new]: 5\r\naccess_group_idaccess_group [new]: 2\r\n'),
 (779,'2020-04-06 20:54:50','::1','admin','user_group','add','---Keys\r\niduser_group : 12\r\n---Fields\r\nuser_iduser [new]: 6\r\naccess_group_idaccess_group [new]: 8\r\n'),
 (780,'2020-04-06 20:55:01','::1','admin','user_group','add','---Keys\r\niduser_group : 13\r\n---Fields\r\nuser_iduser [new]: 6\r\naccess_group_idaccess_group [new]: 3\r\n');
INSERT INTO `wf2_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (781,'2020-04-06 20:55:28','::1','admin','utility_group','add','---Keys\r\nidutility_group : 8\r\n---Fields\r\nct_utility_idct_utility [new]: 4\r\naccess_group_idaccess_group [new]: 7\r\n'),
 (782,'2020-04-06 20:56:22','::1','admin','status_group','add','---Keys\r\nidstatus_group : 18\r\n---Fields\r\nct_status_idct_status [new]: 10\r\naccess_group_idaccess_group [new]: 8\r\n'),
 (783,'2020-04-06 20:56:29','::1','admin','status_group','add','---Keys\r\nidstatus_group : 19\r\n---Fields\r\nct_status_idct_status [new]: 12\r\naccess_group_idaccess_group [new]: 8\r\n'),
 (784,'2020-04-06 20:56:41','::1','admin','status_group','add','---Keys\r\nidstatus_group : 20\r\n---Fields\r\nct_status_idct_status [new]: 13\r\naccess_group_idaccess_group [new]: 8\r\n'),
 (785,'2020-04-06 20:56:52','::1','admin','status_group','add','---Keys\r\nidstatus_group : 21\r\n---Fields\r\nct_status_idct_status [new]: 11\r\naccess_group_idaccess_group [new]: 7\r\n'),
 (786,'2020-04-06 20:59:34','::1','admin','user','logout',''),
 (787,'2020-04-06 20:59:43','::1','rrhh1','user','login',''),
 (788,'2020-04-06 20:59:45','::1','rrhh1','select_process','edit','---Keys\r\niduser : 5\r\n'),
 (789,'2020-04-06 21:00:09','::1','rrhh1','user','logout',''),
 (790,'2020-04-06 21:00:22','::1','accounting1','user','login',''),
 (791,'2020-04-06 21:00:24','::1','accounting1','select_process','edit','---Keys\r\niduser : 6\r\n'),
 (792,'2020-04-06 21:02:59','::1','accounting1','user','logout',''),
 (793,'2020-04-06 21:03:09','::1','admin','user','login',''),
 (794,'2020-04-06 21:03:20','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (795,'2020-04-06 21:04:08','::1','admin','user','logout',''),
 (796,'2020-04-06 21:04:20','::1','rrhh1','user','login',''),
 (797,'2020-04-06 21:04:22','::1','rrhh1','select_process','edit','---Keys\r\niduser : 5\r\n'),
 (798,'2020-04-06 21:04:39','::1','rrhh1','user','logout',''),
 (799,'2020-04-06 21:04:45','::1','admin','user','login',''),
 (800,'2020-04-06 21:04:47','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (801,'2020-04-06 21:06:36','::1','admin','user','logout',''),
 (802,'2020-04-06 21:06:44','::1','rrhh1','user','login',''),
 (803,'2020-04-06 21:06:46','::1','rrhh1','select_process','edit','---Keys\r\niduser : 5\r\n'),
 (804,'2020-04-06 21:07:10','::1','rrhh1','user','logout',''),
 (805,'2020-04-06 21:07:24','::1','accounting1','user','login',''),
 (806,'2020-04-06 21:07:26','::1','accounting1','select_process','edit','---Keys\r\niduser : 6\r\n'),
 (807,'2020-04-06 21:10:28','::1','accounting1','user','logout',''),
 (808,'2020-04-06 21:10:34','::1','admin','user','login',''),
 (809,'2020-04-06 21:10:45','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (810,'2020-04-06 21:25:37','::1','admin','user','logout',''),
 (811,'2020-04-06 21:25:44','::1','rrhh1','user','login',''),
 (812,'2020-04-06 21:25:46','::1','rrhh1','select_process','edit','---Keys\r\niduser : 5\r\n'),
 (813,'2020-04-06 21:26:38','::1','rrhh1','user','logout',''),
 (814,'2020-04-07 14:16:19','::1','user1','user','login',''),
 (815,'2020-04-07 14:16:21','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n'),
 (816,'2020-04-07 14:33:22','::1','user1','user','logout',''),
 (817,'2020-04-07 16:41:21','::1','admin','user','login',''),
 (818,'2020-04-07 16:41:37','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (819,'2020-04-07 16:54:48','::1','admin','user','logout',''),
 (820,'2020-04-07 16:54:56','::1','user1','user','login',''),
 (821,'2020-04-07 16:54:59','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n'),
 (822,'2020-04-07 16:55:36','::1','user1','user','logout',''),
 (823,'2020-04-07 16:55:43','::1','admin','user','login',''),
 (824,'2020-04-07 16:55:46','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (825,'2020-04-07 17:02:15','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (826,'2020-04-07 17:04:21','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (827,'2020-04-07 17:04:52','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (828,'2020-04-07 17:13:56','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (829,'2020-04-07 17:15:03','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (830,'2020-04-07 17:21:13','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (831,'2020-04-07 17:21:49','::1','admin','user','logout',''),
 (832,'2020-04-07 17:21:57','::1','user1','user','login',''),
 (833,'2020-04-07 17:22:00','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n'),
 (834,'2020-04-07 17:23:02','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (835,'2020-04-07 17:27:55','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (836,'2020-04-07 17:33:55','::1','user1','select_process','edit','---Keys\r\niduser : 2\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (837,'2020-04-07 17:37:12','::1','user1','user','logout',''),
 (838,'2020-04-07 17:37:18','::1','admin','user','login',''),
 (839,'2020-04-07 17:37:21','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (840,'2020-04-07 17:37:28','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 1\r\nlastProcessWorked [new]: 2\r\n'),
 (841,'2020-04-07 17:40:51','::1','admin','process','edit','---Keys\r\nidprocess : 2\r\n---Fields\r\nurlView [old]: ex04_expedient_view.php\r\nurlView [new]: ex01_expedient_view.php\r\n'),
 (842,'2020-04-07 17:41:10','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (843,'2020-04-07 17:42:30','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n---Fields\r\nlastProcessWorked [old]: 2\r\nlastProcessWorked [new]: 1\r\n'),
 (844,'2020-04-07 20:12:49','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\nct_proceeding_idct_proceeding [old]: 2\r\nct_proceeding_idct_proceeding [new]: 6\r\nlastUpdateDate [old]: 2020-04-05 13:34:32\r\nlastUpdateDate [new]: 2020-04-07 20:12:49\r\n'),
 (845,'2020-04-07 20:18:06','::1','admin','config','edit','---Keys\r\nidconfig : 5\r\n---Fields\r\nvalue [old]: C:/Apache24/htdocs/workflow2/\r\nvalue [new]: ../../\r\n'),
 (846,'2020-04-07 20:18:42','::1','admin','user','logout',''),
 (847,'2020-04-07 20:18:48','::1','admin','user','login',''),
 (848,'2020-04-07 20:18:50','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (849,'2020-04-07 20:34:38','::1','admin','user','logout',''),
 (850,'2020-04-07 20:34:49','::1','admin','user','login',''),
 (851,'2020-04-07 20:34:51','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (852,'2020-04-08 12:20:38','::1','admin','user','login',''),
 (853,'2020-04-08 12:20:40','::1','admin','select_process','edit','---Keys\r\niduser : 1\r\n'),
 (854,'2020-04-08 12:23:23','::1','admin','user','logout',''),
 (855,'2020-04-08 12:40:25','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla_ejemplo_1_07mvq257.php\",\"usrName\":\"plantilla_ejemplo_1.php\",\"size\":2525,\"type\":\"text\\/html\",\"searchStr\":\"plantilla_ejemplo_1.php,!plantilla ejemplo_1.docx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-04 14:18:11\r\nlastUpdateDate [new]: 2020-04-08 12:40:25\r\n'),
 (856,'2020-04-08 12:55:59','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nlastUpdateDate [old]: 2020-04-08 12:40:25\r\nlastUpdateDate [new]: 2020-04-08 12:55:58\r\n'),
 (857,'2020-04-08 13:07:11','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\nconditionFile [old]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_p49amrd7.php\",\"usrName\":\"CondicionInformeEjemplo.php\",\"size\":318,\"type\":\"text\\/html\",\"searchStr\":\"CondicionInformeEjemplo.php,!:sStrEnd\"}]\r\nconditionFile [new]: \r\nlastUpdateDate [old]: 2020-04-08 12:55:58\r\nlastUpdateDate [new]: 2020-04-08 13:07:11\r\n'),
 (858,'2020-04-08 13:07:46','::1','admin','ct_report','edit','---Keys\r\nidct_report : 1\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/plantilla ejemplo_1_ghlg35a2.docx\",\"usrName\":\"plantilla ejemplo_1.docx\",\"size\":15520,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"plantilla ejemplo_1.docx,!plantilla_ejemplo_1.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\\r\nconditionFile [old]: \r\nconditionFile [new]: [{\"name\":\"files\\/conditions_report\\/CondicionInformeEjemplo_gml8zb95.txt\",\"usrName\":\"CondicionInformeEjemplo.txt\",\"size\":318,\"type\":\"text\\/plain\",\"searchStr\":\"CondicionInformeEjemplo.txt,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-08 13:07:11\r\nlastUpdateDate [new]: 2020-04-08 13:07:46\r\n'),
 (859,'2020-04-08 13:08:36','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_qy9853fx.php\",\"usrName\":\"modelo_2.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_2016amw5.txt\",\"usrName\":\"modelo_2.txt\",\"\r\nlastUpdateDate [old]: 2020-04-07 20:12:49\r\nlastUpdateDate [new]: 2020-04-08 13:08:36\r\n'),
 (860,'2020-04-08 13:09:13','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_gr1axvxy.php\",\"usrName\":\"modelo_2.php\",\"size\":4190,\"type\":\"text\\/html\",\"searchStr\":\"modelo_2.php,!modelo_2.xlsx,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-offic\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_4jzyf5qn.txt\",\"usrName\":\"modelo_2.txt\",\"\r\nlastUpdateDate [old]: 2020-04-05 13:32:07\r\nlastUpdateDate [new]: 2020-04-08 13:09:13\r\n'),
 (861,'2020-04-08 13:09:25','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.php,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_urdsyn69.php\",\"usrName\":\"modelo_3.php\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-06 12:15:49\r\nlastUpdateDate [new]: 2020-04-08 13:09:25\r\n'),
 (862,'2020-04-08 13:09:41','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_6u7q4n94.txt\",\"usrName\":\"modelo_3.txt\",\"\r\nlastUpdateDate [old]: 2020-04-08 13:09:25\r\nlastUpdateDate [new]: 2020-04-08 13:09:41\r\n'),
 (863,'2020-04-08 13:13:13','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_2016amw5.txt\",\"usrName\":\"modelo_2.txt\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-08 13:08:36\r\nlastUpdateDate [new]: 2020-04-08 13:13:13\r\n'),
 (864,'2020-04-08 13:13:18','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_4jzyf5qn.txt\",\"usrName\":\"modelo_2.txt\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-08 13:09:13\r\nlastUpdateDate [new]: 2020-04-08 13:13:18\r\n'),
 (865,'2020-04-08 13:13:24','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_6u7q4n94.txt\",\"usrName\":\"modelo_3.txt\",\"\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\nlastUpdateDate [old]: 2020-04-08 13:09:41\r\nlastUpdateDate [new]: 2020-04-08 13:13:24\r\n'),
 (866,'2020-04-08 13:13:42','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_8q2js1nk.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_vno0lkiy.txt\",\"usrName\":\"modelo_2.txt\",\"\r\nlastUpdateDate [old]: 2020-04-08 13:13:13\r\nlastUpdateDate [new]: 2020-04-08 13:13:42\r\n'),
 (867,'2020-04-08 13:13:59','::1','admin','ct_report','edit','---Keys\r\nidct_report : 4\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_2_20a23593.xlsx\",\"usrName\":\"modelo_2.xlsx\",\"size\":10615,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_2.xlsx,!modelo_2.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_2_bzpn70rq.txt\",\"usrName\":\"modelo_2.txt\",\"\r\nlastUpdateDate [old]: 2020-04-08 13:13:18\r\nlastUpdateDate [new]: 2020-04-08 13:13:59\r\n'),
 (868,'2020-04-08 13:14:11','::1','admin','ct_report','edit','---Keys\r\nidct_report : 5\r\n---Fields\r\ncodeTemplateFiles [old]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!:sStrEnd\"}]\r\ncodeTemplateFiles [new]: [{\"name\":\"files\\/code_report\\/modelo_3_38txvmnw.xlsx\",\"usrName\":\"modelo_3.xlsx\",\"size\":10761,\"type\":\"application\\/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"searchStr\":\"modelo_3.xlsx,!modelo_3.txt,!:sStrEnd\"},{\"name\":\"files\\/code_report\\/modelo_3_cyv1j0ib.txt\",\"usrName\":\"modelo_3.txt\",\"\r\nlastUpdateDate [old]: 2020-04-08 13:13:24\r\nlastUpdateDate [new]: 2020-04-08 13:14:11\r\n'),
 (869,'2020-04-08 13:16:05','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 5\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-06 12:51:47\r\nlastUpdateDate [new]: 2020-04-08 13:16:00\r\n'),
 (870,'2020-04-08 13:16:16','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-08 13:16:00\r\nlastUpdateDate [new]: 2020-04-08 13:16:08\r\n'),
 (871,'2020-04-08 13:16:42','::1','admin','ct_report','edit','---Keys\r\nidct_report : 3\r\n---Fields\r\nct_proceeding_idct_proceeding [old]: 6\r\nct_proceeding_idct_proceeding [new]: 2\r\nlastUpdateDate [old]: 2020-04-08 13:13:42\r\nlastUpdateDate [new]: 2020-04-08 13:16:42\r\n'),
 (872,'2020-04-08 13:16:52','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-08 13:16:08\r\nlastUpdateDate [new]: 2020-04-08 13:16:47\r\n'),
 (873,'2020-04-08 13:17:08','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 1\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-08 13:16:47\r\nlastUpdateDate [new]: 2020-04-08 13:17:02\r\n'),
 (874,'2020-04-08 13:17:37','::1','admin','document','delete','---Keys\r\niddocument : 57\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000066/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-08 13:16:16\r\nlastUpdateDate [old]: 2020-04-08 13:16:16\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200408131616.docx\",\"usrName\":\"Peticion_20200408131616.docx\",\"size\":14202,\"type\":\"application/word\"}]\r\n'),
 (875,'2020-04-08 13:17:37','::1','admin','document','delete','---Keys\r\niddocument : 56\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000065/2020\r\nTitle [old]: Report_Expedient\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-05 13:35:02\r\nlastUpdateDate [old]: 2020-04-05 13:35:02\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Report_Expedient_20200405133502.xlsx\",\"usrName\":\"Report_Expedient_20200405133502.xlsx\",\"size\":10317,\"type\":\"application/excel\"}]\r\n'),
 (876,'2020-04-08 13:17:37','::1','admin','document','delete','---Keys\r\niddocument : 55\r\n---Fields\r\nexpedient_idexpedient [old]: 1\r\nDocumentNum [old]: DOC/000064/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-05 13:35:02\r\nlastUpdateDate [old]: 2020-04-05 13:35:02\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000004_2020/Peticion_20200405133502.docx\",\"usrName\":\"Peticion_20200405133502.docx\",\"size\":14202,\"type\":\"application/word\"}]\r\n'),
 (877,'2020-04-08 13:18:08','::1','admin','document','delete','---Keys\r\niddocument : 21\r\n---Fields\r\nexpedient_idexpedient [old]: 2\r\nDocumentNum [old]: DOC/000023/2020\r\nTitle [old]: Peticion\r\nentryOrExit [old]: 1\r\ncreationDate [old]: 2020-04-02 14:23:35\r\nlastUpdateDate [old]: 2020-04-02 14:23:35\r\nlastUpdateUser [old]: admin\r\nfileContent [old]: [{\"name\":\"files/document/EX04_000008_2020/Peticion_20200402142335.docx\",\"usrName\":\"Peticion_20200402142335.docx\",\"size\":14190,\"type\":\"application/word\"}]\r\n'),
 (878,'2020-04-08 13:18:17','::1','admin','ex04_utility','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 4\r\nct_status_idct_status [new]: 3\r\nlastUpdateDate [old]: 2020-04-03 18:38:00\r\nlastUpdateDate [new]: 2020-04-08 13:18:12\r\n'),
 (879,'2020-04-08 13:18:25','::1','admin','ex04_proceeding','edit','---Keys\r\nidexpedient : 2\r\n---Fields\r\nct_status_idct_status [old]: 3\r\nct_status_idct_status [new]: 4\r\nlastUpdateDate [old]: 2020-04-08 13:18:12\r\nlastUpdateDate [new]: 2020-04-08 13:18:20\r\n');
/*!40000 ALTER TABLE `wf2_audit` ENABLE KEYS */;


--
-- Definition of table `wf2_locking`
--

DROP TABLE IF EXISTS `wf2_locking`;
CREATE TABLE `wf2_locking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table` varchar(300) NOT NULL,
  `startdatetime` datetime NOT NULL,
  `confirmdatetime` datetime NOT NULL,
  `keys` varchar(300) NOT NULL,
  `sessionid` varchar(100) NOT NULL,
  `userid` varchar(300) NOT NULL,
  `action` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=513 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wf2_locking`
--

/*!40000 ALTER TABLE `wf2_locking` DISABLE KEYS */;
INSERT INTO `wf2_locking` (`id`,`table`,`startdatetime`,`confirmdatetime`,`keys`,`sessionid`,`userid`,`action`) VALUES 
 (270,'expedient','2020-04-03 18:38:00','2020-04-03 18:38:00','2','v3atrrkn0lgipsktu1t6or1gg8','admin',1),
 (273,'expedient','2020-04-03 18:38:16','2020-04-03 18:38:16','3','v3atrrkn0lgipsktu1t6or1gg8','admin',1),
 (459,'ex01_utility','2020-04-06 19:52:46','2020-04-06 19:52:46','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (460,'ex01_utility','2020-04-06 19:53:10','2020-04-06 19:53:10','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (477,'ex01_proceeding','2020-04-06 20:58:41','2020-04-06 20:58:41','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (478,'ex01_proceeding','2020-04-06 20:58:58','2020-04-06 20:58:58','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (479,'ex01_proceeding','2020-04-06 20:59:03','2020-04-06 20:59:03','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (480,'ex01_proceeding','2020-04-06 21:00:41','2020-04-06 21:00:41','4','ct5j49h1j6ic6cdblg0mh6vkv7','accounting1',1),
 (482,'expedient','2020-04-07 17:21:37','2020-04-07 17:21:37','1','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (483,'ex04_expedient','2020-04-07 17:21:38','2020-04-07 17:21:38','1','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (484,'expedient','2020-04-07 17:39:57','2020-04-07 17:39:57','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (485,'ex01_expedient','2020-04-07 17:40:18','2020-04-07 17:40:18','4','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (498,'ex04_report','2020-04-08 13:09:46','2020-04-08 13:09:46','1','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (499,'ex04_report','2020-04-08 13:14:15','2020-04-08 13:14:15','1','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1),
 (500,'ex04_report','2020-04-08 13:14:39','2020-04-08 13:14:39','1','ct5j49h1j6ic6cdblg0mh6vkv7','admin',1);
/*!40000 ALTER TABLE `wf2_locking` ENABLE KEYS */;


--
-- Definition of table `wf2_settings`
--

DROP TABLE IF EXISTS `wf2_settings`;
CREATE TABLE `wf2_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wf2_settings`
--

/*!40000 ALTER TABLE `wf2_settings` DISABLE KEYS */;
INSERT INTO `wf2_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":658.4,\"thWidths\":{\"grid_headcell_icons\":27,\"grid_headcell_checkbox\":13,\"grid_headcell_details\":94.4,\"grid_headcell_field\":81,\"grid_headcell_field1\":56,\"grid_headcell_field2\":72,\"grid_headcell_field3\":154,\"grid_headcell_field4\":66,\"grid_headcell_field5\":65,\"grid_headcell_field6\":13}}','super_catalog'),
 (2,4,NULL,'admin',NULL,'[\"super_catalog_idsuper_catalog\",\"language\",\"catalogNum\",\"catalogCode\",\"groupNum\",\"description\",\"idcatalog\"]','catalog'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":832.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":12.4,\"grid_headcell_field\":80.4,\"grid_headcell_field1\":55.4,\"grid_headcell_field2\":71.4,\"grid_headcell_field3\":173.4,\"grid_headcell_field5\":64.4,\"grid_headcell_field4\":253.4,\"grid_headcell_field6\":9.4}}','catalog'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":1016.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":19.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":88.4,\"grid_headcell_field1\":152.4,\"grid_headcell_field2\":79.4,\"grid_headcell_field3\":146.4,\"grid_headcell_field4\":138.4,\"grid_headcell_field5\":125.4,\"grid_headcell_field6\":111.4}}','access_group'),
 (5,4,NULL,'admin',NULL,'[\"idaccess_group\",\"process_idprocess\",\"code\",\"title\",\"canAddExpedient\",\"canEditExpedient\",\"canViewExpedient\"]','access_group'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":683.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":297.4,\"grid_headcell_field2\":282.4}}','user_group'),
 (7,2,NULL,'admin',NULL,'{\"gridWidth\":773.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":59.4,\"grid_headcell_field1\":210.4,\"grid_headcell_field2\":296.4,\"grid_headcell_field3\":60.4}}','ct_status'),
 (8,2,NULL,'admin',NULL,'{\"gridWidth\":714.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":26.4,\"grid_headcell_field1\":183.4,\"grid_headcell_field2\":158.4,\"grid_headcell_field3\":104.4,\"grid_headcell_field4\":84.4}}','ct_proceeding'),
 (9,2,NULL,'admin',NULL,'{\"gridWidth\":609.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":39.4,\"grid_headcell_field1\":260.4,\"grid_headcell_field2\":215.4}}','status_proceeding'),
 (10,2,NULL,'admin',NULL,'{\"gridWidth\":668.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":22.4,\"grid_headcell_field1\":257.4,\"grid_headcell_field2\":294.4}}','proceeding_status'),
 (11,2,NULL,'admin',NULL,'{\"gridWidth\":861.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":184.4,\"grid_headcell_field2\":176.4,\"grid_headcell_field3\":104.4,\"grid_headcell_field4\":230.4}}','ct_utility'),
 (12,3,'0','admin',NULL,'[\".dummyField\",\"superCodeStatus\",\"superCodeProceeding\",\"superCodeUtility\",\"urlAdd\",\"urlEdit\",\"urlView\"]','process'),
 (13,2,NULL,'admin',NULL,'{\"gridWidth\":756.4,\"thWidths\":{\"grid_headcell_icons\":33.4,\"grid_headcell_checkbox\":21.4,\"grid_headcell_details\":38.4,\"grid_headcell_field\":30.4,\"grid_headcell_field1\":56.4,\"grid_headcell_field2\":519.4}}','process'),
 (14,2,NULL,'admin',NULL,'{\"gridWidth\":669.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field1\":23.4,\"grid_headcell_field3\":206.4,\"grid_headcell_field2\":345.4}}','config'),
 (15,2,NULL,'admin',NULL,'{\"gridWidth\":899.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":144.4,\"grid_headcell_field2\":137.4,\"grid_headcell_field3\":121.4,\"grid_headcell_field4\":219.4,\"grid_headcell_field5\":66.4,\"grid_headcell_field6\":68.4}}','ct_report'),
 (16,2,NULL,'admin',NULL,'{\"gridWidth\":786.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":17.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":81.4,\"grid_headcell_field2\":226.4,\"grid_headcell_field3\":185.4,\"grid_headcell_field4\":86.4,\"grid_headcell_field5\":34.4}}','user'),
 (17,2,NULL,'admin',NULL,'{\"gridWidth\":899.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":192.4,\"grid_headcell_field2\":389.4,\"grid_headcell_field3\":204.4}}','ct_templates'),
 (18,2,NULL,'admin',NULL,'{\"gridWidth\":736.4,\"thWidths\":{\"grid_headcell_icons\":27.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":198.4,\"grid_headcell_field2\":433.4}}','utility_group'),
 (19,2,NULL,'admin',NULL,'{\"gridWidth\":671,\"thWidths\":{\"grid_headcell_field\":13,\"grid_headcell_field1\":318,\"grid_headcell_field2\":316}}','status_group'),
 (20,2,NULL,'admin',NULL,'{\"gridWidth\":851,\"thWidths\":{\"grid_headcell_icons\":27,\"grid_headcell_checkbox\":22,\"grid_headcell_field\":28,\"grid_headcell_field1\":98,\"grid_headcell_field2\":138,\"grid_headcell_field3\":86,\"grid_headcell_field4\":178,\"grid_headcell_field5\":122,\"grid_headcell_field6\":79}}','alerts'),
 (21,2,NULL,'admin',NULL,'{\"gridWidth\":939,\"thWidths\":{\"grid_headcell_icons\":27,\"grid_headcell_checkbox\":22,\"grid_headcell_field\":28,\"grid_headcell_field1\":116,\"grid_headcell_field2\":124,\"grid_headcell_field3\":129,\"grid_headcell_field4\":70,\"grid_headcell_field5\":106,\"grid_headcell_field6\":244}}','document'),
 (22,2,NULL,'admin',NULL,'{\"gridWidth\":686.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":101.4,\"grid_headcell_field2\":152.4,\"grid_headcell_field3\":195.4,\"grid_headcell_field4\":114.4}}','file'),
 (23,2,NULL,'admin',NULL,'{\"gridWidth\":1158,\"thWidths\":{\"grid_headcell_icons\":22,\"grid_headcell_field\":28,\"grid_headcell_field2\":178,\"grid_headcell_field3\":191,\"grid_headcell_field4\":201,\"grid_headcell_field5\":200,\"grid_headcell_field1\":132,\"grid_headcell_field6\":142}}','process_logbook'),
 (24,2,NULL,'admin',NULL,'{\"gridWidth\":916.4,\"thWidths\":{\"grid_headcell_icons\":18.4,\"grid_headcell_field\":19.4,\"grid_headcell_field1\":103.4,\"grid_headcell_field2\":118.4,\"grid_headcell_field3\":196.4,\"grid_headcell_field4\":120.4,\"grid_headcell_field5\":109.4,\"grid_headcell_field6\":97.4,\"grid_headcell_field7\":71.4,\"grid_headcell_field10\":52.4,\"grid_headcell_field11\":40.4,\"grid_headcell_field8\":88.4,\"grid_headcell_field9\":96.4,\"grid_headcell_field12\":136.4}}','expedient_tray'),
 (25,3,'0','admin',NULL,'[\".dummyField\",\"idexpedient\",\"lastUpdateDate\",\"observations\",\"lastUpdateUser\"]','expedient_tray'),
 (26,4,NULL,'admin',NULL,'[\"idexpedient\",\"codeExpedient\",\"title\",\"ct_status_idct_status\",\"assignedUser\",\"creationDate\",\"lastUpdateDate\",\"finishDate\",\"Active\",\"Urgent\",\"creationUser\",\"observations\",\"lastUpdateUser\"]','expedient_tray'),
 (27,2,NULL,'admin',NULL,'{\"gridWidth\":918.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":82.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":97.4,\"grid_headcell_field2\":57.4,\"grid_headcell_field3\":179.4,\"grid_headcell_field4\":102.4,\"grid_headcell_field5\":77.4,\"grid_headcell_field6\":96.4,\"grid_headcell_field7\":63.4}}','expedient'),
 (28,3,'0','admin',NULL,'[\".dummyField\"]','expedient'),
 (29,2,NULL,'user1',NULL,'{\"gridWidth\":560.233334,\"thWidths\":{\"grid_headcell_icons\":20.233334,\"grid_headcell_field\":10.233334,\"grid_headcell_field1\":194.233334,\"grid_headcell_field2\":192.233334,\"grid_headcell_field3\":95.233334}}','ct_status'),
 (30,2,NULL,'user1',NULL,'{\"gridWidth\":879.233334,\"thWidths\":{\"grid_headcell_icons\":20.233334,\"grid_headcell_field\":10.233334,\"grid_headcell_field1\":106.233334,\"grid_headcell_field2\":70.233334,\"grid_headcell_field3\":33.233334,\"grid_headcell_field4\":269.233334,\"grid_headcell_field5\":208.233334,\"grid_headcell_field6\":83.233334}}','process_logbook'),
 (31,2,NULL,'user1',NULL,'{\"gridWidth\":1030,\"thWidths\":{\"grid_headcell_icons\":22,\"grid_headcell_field\":11,\"grid_headcell_field1\":107,\"grid_headcell_field2\":117,\"grid_headcell_field3\":110,\"grid_headcell_field4\":288,\"grid_headcell_field5\":185,\"grid_headcell_field6\":125}}','alerts'),
 (32,4,NULL,'admin',NULL,'[\"idstatus_group\",\"ct_status_idct_status\",\"access_group_idaccess_group\"]','status_group'),
 (33,2,NULL,'rrhh1',NULL,'{\"gridWidth\":387.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_details\":11.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":29.4,\"grid_headcell_field2\":269.4}}','process'),
 (34,3,'0','user1',NULL,'[\".dummyField\",\"lastUpdateDate\",\"creationUser\",\"observations\",\"Active\",\"lastUpdateUser\"]','expedient_tray'),
 (35,2,NULL,'user1',NULL,'{\"gridWidth\":896.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":115.4,\"grid_headcell_field2\":127.4,\"grid_headcell_field3\":189.4,\"grid_headcell_field4\":81.4,\"grid_headcell_field5\":113.4,\"grid_headcell_field6\":0.4,\"grid_headcell_field7\":108.4,\"grid_headcell_field10\":0.4,\"grid_headcell_field11\":45.4,\"grid_headcell_field8\":0.4,\"grid_headcell_field9\":0.4,\"grid_headcell_field12\":0.4}}','expedient_tray');
/*!40000 ALTER TABLE `wf2_settings` ENABLE KEYS */;


--
-- Definition of table `wf2_uggroups`
--

DROP TABLE IF EXISTS `wf2_uggroups`;
CREATE TABLE `wf2_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wf2_uggroups`
--

/*!40000 ALTER TABLE `wf2_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `wf2_uggroups` ENABLE KEYS */;


--
-- Definition of table `wf2_ugmembers`
--

DROP TABLE IF EXISTS `wf2_ugmembers`;
CREATE TABLE `wf2_ugmembers` (
  `UserName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  PRIMARY KEY (`UserName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wf2_ugmembers`
--

/*!40000 ALTER TABLE `wf2_ugmembers` DISABLE KEYS */;
INSERT INTO `wf2_ugmembers` (`UserName`,`GroupID`) VALUES 
 ('admin',-1);
/*!40000 ALTER TABLE `wf2_ugmembers` ENABLE KEYS */;


--
-- Definition of table `wf2_ugrights`
--

DROP TABLE IF EXISTS `wf2_ugrights`;
CREATE TABLE `wf2_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wf2_ugrights`
--

/*!40000 ALTER TABLE `wf2_ugrights` DISABLE KEYS */;
INSERT INTO `wf2_ugrights` (`TableName`,`GroupID`,`AccessMask`) VALUES 
 ('access_group',-1,'ADESPIM'),
 ('alerts',-1,'ADESPIM'),
 ('catalog',-1,'ADESPIM'),
 ('config',-1,'ADESPIM'),
 ('ct_num_document',-1,'AEDSPI'),
 ('ct_num_expedient',-1,'AEDSPI'),
 ('ct_proceeding',-1,'ADESPIM'),
 ('ct_report',-1,'ADESPIM'),
 ('ct_status',-1,'ADESPIM'),
 ('ct_templates',-2,'S'),
 ('ct_templates',-1,'ADESPIM'),
 ('ct_utility',-1,'ADESPIM'),
 ('diagram',-1,'S'),
 ('document',-1,'ADESPIM'),
 ('expedient',-2,'S'),
 ('expedient',-1,'ADESPIM'),
 ('expedient_tray',-2,'S'),
 ('expedient_tray',-1,'S'),
 ('file',-1,'ADESPIM'),
 ('lv_access_group',-2,'S'),
 ('lv_catalog',-2,'S'),
 ('lv_catalog',-1,'ADESPIM'),
 ('lv_proceeding',-2,'S'),
 ('lv_status',-2,'S'),
 ('lv_user_process',-2,'S'),
 ('lv_utility',-2,'S'),
 ('proceeding_status',-1,'ADESPIM'),
 ('process',-2,'S'),
 ('process',-1,'ADESPIM'),
 ('Processing Flow',-2,'S'),
 ('Processing Flow',-1,'S'),
 ('process_logbook',-1,'ADESPIM'),
 ('select_process',-2,'E'),
 ('select_process',-1,'E'),
 ('status_group',-1,'ADESPIM'),
 ('status_proceeding',-1,'ADESPIM'),
 ('super_catalog',-1,'ADESPIM'),
 ('user',-1,'ADESPIM'),
 ('user_group',-1,'ADESPIM'),
 ('utility_group',-1,'ADESPIM');
/*!40000 ALTER TABLE `wf2_ugrights` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
